/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.satisfy.wildernature.WilderNature;
import net.satisfy.wildernature.core.entity.HedgehogEntity;
import net.satisfy.wildernature.core.entity.animation.HedgehogAnimation;
import org.jetbrains.annotations.NotNull;

public class HedgehogModel<T extends HedgehogEntity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(WilderNature.identifier("hedgehog"), "main");
    private final ModelPart root;

    public HedgehogModel(ModelPart root) {
        this.root = root;
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)21.0f, (float)0.0f));
        PartDefinition hedgehog = root.addOrReplaceChild("hedgehog", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition torso = hedgehog.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -3.984f, -3.9564f, 6.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 0).mirror().addBox(-1.0f, -0.984f, -5.9564f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)0.984f, (float)-0.0436f));
        PartDefinition spikes = torso.addOrReplaceChild("spikes", CubeListBuilder.create(), PartPose.offset((float)-1.3536f, (float)-4.3375f, (float)0.5436f));
        PartDefinition spikes_r1 = spikes.addOrReplaceChild("spikes_r1", CubeListBuilder.create().texOffs(14, 0).addBox(-0.5f, 0.0f, -4.5f, 1.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.7071f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition spikes_r2 = spikes.addOrReplaceChild("spikes_r2", CubeListBuilder.create().texOffs(14, 0).addBox(-0.5f, 0.0f, -4.5f, 1.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition spikes_r3 = spikes.addOrReplaceChild("spikes_r3", CubeListBuilder.create().texOffs(16, 1).addBox(-0.5f, 0.0f, -2.5f, 1.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.7071f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition spikes_r4 = spikes.addOrReplaceChild("spikes_r4", CubeListBuilder.create().texOffs(15, 0).addBox(-0.5f, 0.0f, -3.5f, 1.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.7071f, (float)1.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition spikes_r5 = spikes.addOrReplaceChild("spikes_r5", CubeListBuilder.create().texOffs(16, 1).addBox(-0.5f, 0.0f, -2.5f, 1.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition spikes_r6 = spikes.addOrReplaceChild("spikes_r6", CubeListBuilder.create().texOffs(1, 13).addBox(-0.5f, 0.0f, -2.0f, 6.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.1464f, (float)-1.0607f, (float)4.9142f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition spikes_r7 = spikes.addOrReplaceChild("spikes_r7", CubeListBuilder.create().texOffs(1, 13).addBox(-0.5f, 0.0f, -2.0f, 6.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.1464f, (float)1.9393f, (float)4.9142f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition spikes_r8 = spikes.addOrReplaceChild("spikes_r8", CubeListBuilder.create().texOffs(0, 13).addBox(-0.5f, 0.0f, -2.0f, 6.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.1464f, (float)0.4393f, (float)4.9142f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition spikes_r9 = spikes.addOrReplaceChild("spikes_r9", CubeListBuilder.create().texOffs(15, 0).addBox(-0.5f, 0.0f, -3.5f, 1.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)1.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition spikes_r10 = spikes.addOrReplaceChild("spikes_r10", CubeListBuilder.create().texOffs(15, 1).addBox(-0.5f, 0.0f, -3.5f, 1.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.7071f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition spikes_r11 = spikes.addOrReplaceChild("spikes_r11", CubeListBuilder.create().texOffs(15, 1).addBox(-0.5f, 0.0f, -3.5f, 1.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition leftEar = torso.addOrReplaceChild("leftEar", CubeListBuilder.create().texOffs(20, 0).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)-2.984f, (float)-2.9814f, (float)0.0f, (float)0.0f, (float)0.0873f));
        PartDefinition rightEar = torso.addOrReplaceChild("rightEar", CubeListBuilder.create().texOffs(20, 0).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)-2.984f, (float)-2.9814f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        PartDefinition nose = torso.addOrReplaceChild("nose", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-0.509f, (float)-5.4814f));
        PartDefinition rightArm = hedgehog.addOrReplaceChild("rightArm", CubeListBuilder.create().texOffs(0, 4).addBox(-1.0f, -0.5f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.75f, (float)1.5f, (float)-2.75f));
        PartDefinition leftArm = hedgehog.addOrReplaceChild("leftArm", CubeListBuilder.create().texOffs(0, 4).addBox(-1.0f, -0.5f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.75f, (float)1.5f, (float)-2.75f));
        PartDefinition leftLeg = hedgehog.addOrReplaceChild("leftLeg", CubeListBuilder.create().texOffs(0, 4).addBox(-1.0f, -0.5f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.75f, (float)1.5f, (float)2.75f));
        PartDefinition rightLeg = hedgehog.addOrReplaceChild("rightLeg", CubeListBuilder.create().texOffs(0, 4).mirror().addBox(-1.0f, -0.5f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-1.75f, (float)1.5f, (float)2.75f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.animateWalk(HedgehogAnimation.walk, limbSwing, limbSwingAmount, 1.0f, 2.5f);
        if (entity.getDeltaMovement().multiply(1.0, 0.0, 1.0).length() != 0.0) {
            this.animate(((HedgehogEntity)((Object)entity)).idleAnimationState, HedgehogAnimation.walk, ageInTicks, 1.0f);
        } else {
            this.animate(((HedgehogEntity)((Object)entity)).idleAnimationState, HedgehogAnimation.idle, ageInTicks, 1.0f);
        }
        this.animate(((HedgehogEntity)((Object)entity)).sniffAnimationState, HedgehogAnimation.sniff, ageInTicks, 1.0f);
    }

    public void renderToBuffer(PoseStack matrices, VertexConsumer vertexConsumer, int light, int overlay, int alpha) {
        this.root.render(matrices, vertexConsumer, light, overlay, alpha);
    }

    @NotNull
    public ModelPart root() {
        return this.root;
    }
}

