/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.integration.gui.screen;

import codechicken.lib.data.MCDataOutput;
import codechicken.lib.packet.PacketCustom;
import codechicken.multipart.api.part.MultiPart;
import java.util.Objects;
import mrtjp.projectred.integration.IntegrationNetwork;
import mrtjp.projectred.integration.part.ComplexGatePart;
import mrtjp.projectred.integration.part.GatePart;
import mrtjp.projectred.lib.Point;
import mrtjp.projectred.redui.ButtonNode;
import mrtjp.projectred.redui.RedUINode;
import mrtjp.projectred.redui.RedUIScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class CounterScreen
extends RedUIScreen {
    private static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"projectred_integration", (String)"textures/gui/counter_gate.png");
    private final GatePart gate;
    private final ComplexGatePart.ICounterGuiLogic counterGate;

    public CounterScreen(GatePart gate) {
        super(256, 145, (Component)Component.translatable((String)gate.getType().getRegistryName().toString()));
        this.gate = gate;
        this.counterGate = (ComplexGatePart.ICounterGuiLogic)((Object)gate);
        for (int row = 0; row < 3; ++row) {
            int y = 16 + 40 * row;
            this.createButton(5, y, 40, 20, row, -10);
            this.createButton(46, y, 40, 20, row, -5);
            this.createButton(87, y, 40, 20, row, -1);
            this.createButton(129, y, 40, 20, row, 1);
            this.createButton(170, y, 40, 20, row, 5);
            this.createButton(211, y, 40, 20, row, 10);
        }
    }

    private void createButton(int x, int y, int w, int h, int id, int delta) {
        ButtonNode b = new ButtonNode();
        b.setPosition(x, y);
        b.setSize(w, h);
        b.setButtonText((delta < 0 ? "" : "+") + delta);
        b.setClickFunction(() -> {
            PacketCustom packet = new PacketCustom(IntegrationNetwork.NET_CHANNEL, 4, Minecraft.getInstance().level.registryAccess());
            IntegrationNetwork.writePartIndex((MCDataOutput)packet, (MultiPart)this.gate);
            packet.writeByte(id);
            packet.writeShort(delta);
            packet.sendToServer();
        });
        this.addChild((RedUINode)b);
    }

    public void drawBack(GuiGraphics graphics, Point mouse, float partialFrame) {
        super.drawBack(graphics, mouse, partialFrame);
        int x = this.getFrame().x();
        int y = this.getFrame().y();
        int w = this.getFrame().width();
        graphics.blit(BACKGROUND, x, y, 0, 0, this.getFrame().width(), this.getFrame().height());
        String s = "Maximum: " + this.counterGate.getCounterMax();
        graphics.drawString(this.getFontRenderer(), s, (float)x + (float)(w - this.getFontRenderer().width(s)) / 2.0f, (float)(y + 5), 0x404040, false);
        s = "Increment: " + this.counterGate.getCounterIncr();
        graphics.drawString(this.getFontRenderer(), s, (float)x + (float)(w - this.getFontRenderer().width(s)) / 2.0f, (float)(y + 45), 0x404040, false);
        s = "Decrement: " + this.counterGate.getCounterDecr();
        graphics.drawString(this.getFontRenderer(), s, (float)x + (float)(w - this.getFontRenderer().width(s)) / 2.0f, (float)(y + 85), 0x404040, false);
        s = "State: " + this.counterGate.getCounterValue();
        graphics.drawString(this.getFontRenderer(), s, (float)x + (float)(w - this.getFontRenderer().width(s)) / 2.0f, (float)(y + 125), 0x404040, false);
    }

    public void update() {
        if (!this.gate.hasTile()) {
            Objects.requireNonNull(this.getMinecraft().player).closeContainer();
        }
    }
}

