/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.init.compat.jei;

import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import rearth.oritech.Oritech;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.block.entity.generators.BioGeneratorEntity;
import rearth.oritech.block.entity.generators.FuelGeneratorEntity;
import rearth.oritech.block.entity.generators.LavaGeneratorEntity;
import rearth.oritech.block.entity.generators.SteamEngineEntity;
import rearth.oritech.block.entity.processing.AssemblerBlockEntity;
import rearth.oritech.block.entity.processing.AtomicForgeBlockEntity;
import rearth.oritech.block.entity.processing.CentrifugeBlockEntity;
import rearth.oritech.block.entity.processing.CoolerBlockEntity;
import rearth.oritech.block.entity.processing.FoundryBlockEntity;
import rearth.oritech.block.entity.processing.FragmentForgeBlockEntity;
import rearth.oritech.block.entity.processing.PulverizerBlockEntity;
import rearth.oritech.block.entity.processing.RefineryBlockEntity;
import rearth.oritech.client.ui.BasicMachineScreen;
import rearth.oritech.client.ui.ItemFilterScreen;
import rearth.oritech.client.ui.PlayerModifierScreen;
import rearth.oritech.client.ui.ReactorScreen;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.compat.jei.JeiExclusionZoneHandler;
import rearth.oritech.init.compat.jei.JeiItemFilterGhostHandler;
import rearth.oritech.init.compat.jei.OritechJeiLaserRecipe;
import rearth.oritech.init.compat.jei.OritechJeiParticleCollisionRecipe;
import rearth.oritech.init.compat.jei.OritechJeiRecipeCategory;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.OritechRecipeType;
import rearth.oritech.init.recipes.RecipeContent;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.ScreenProvider;

@JeiPlugin
public class OritechJeiPlugin
implements IModPlugin {
    @NotNull
    public ResourceLocation getPluginUid() {
        return Oritech.id("jei_plugin");
    }

    public void registerCategories(@NotNull IRecipeCategoryRegistration registration) {
        this.registerOritechCategory(registration, RecipeContent.PULVERIZER, BlockContent.PULVERIZER_BLOCK, PulverizerBlockEntity.class);
        this.registerOritechCategory(registration, RecipeContent.GRINDER, BlockContent.FRAGMENT_FORGE_BLOCK, FragmentForgeBlockEntity.class);
        this.registerOritechCategory(registration, RecipeContent.ASSEMBLER, BlockContent.ASSEMBLER_BLOCK, AssemblerBlockEntity.class);
        this.registerOritechCategory(registration, RecipeContent.FOUNDRY, BlockContent.FOUNDRY_BLOCK, FoundryBlockEntity.class);
        this.registerOritechCategory(registration, RecipeContent.REFINERY, BlockContent.REFINERY_BLOCK, RefineryBlockEntity.class);
        this.registerOritechCategory(registration, RecipeContent.COOLER, BlockContent.COOLER_BLOCK, CoolerBlockEntity.class);
        this.registerOritechCategory(registration, RecipeContent.CENTRIFUGE, BlockContent.CENTRIFUGE_BLOCK, CentrifugeBlockEntity.class);
        this.registerOritechCategory(registration, RecipeContent.CENTRIFUGE_FLUID, BlockContent.CENTRIFUGE_BLOCK, CentrifugeBlockEntity.class);
        this.registerOritechCategory(registration, RecipeContent.ATOMIC_FORGE, BlockContent.ATOMIC_FORGE_BLOCK, AtomicForgeBlockEntity.class);
        this.registerOritechCategory(registration, RecipeContent.BIO_GENERATOR, BlockContent.BIO_GENERATOR_BLOCK, BioGeneratorEntity.class);
        this.registerOritechCategory(registration, RecipeContent.FUEL_GENERATOR, BlockContent.FUEL_GENERATOR_BLOCK, FuelGeneratorEntity.class);
        this.registerOritechCategory(registration, RecipeContent.LAVA_GENERATOR, BlockContent.LAVA_GENERATOR_BLOCK, LavaGeneratorEntity.class);
        this.registerOritechCategory(registration, RecipeContent.STEAM_ENGINE, BlockContent.STEAM_ENGINE_BLOCK, SteamEngineEntity.class);
        this.registerCustom(registration, RecipeContent.REACTOR, BlockContent.REACTOR_CONTROLLER, true, List.of(new ScreenProvider.GuiSlot(0, 55, 35)), new InventorySlotAssignment(0, 1, 1, 0));
        registration.addRecipeCategories(new IRecipeCategory[]{new OritechJeiParticleCollisionRecipe(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new OritechJeiLaserRecipe(registration.getJeiHelpers().getGuiHelper())});
    }

    private void registerOritechCategory(IRecipeCategoryRegistration registration, OritechRecipeType type, Block block, Class<? extends MachineBlockEntity> machineClass) {
        registration.addRecipeCategories(new IRecipeCategory[]{new OritechJeiRecipeCategory(type, machineClass, block, registration.getJeiHelpers().getGuiHelper())});
    }

    private void registerCustom(IRecipeCategoryRegistration registration, OritechRecipeType type, Block block, Boolean isGenerator, List<ScreenProvider.GuiSlot> slots, InventorySlotAssignment assignments) {
        registration.addRecipeCategories(new IRecipeCategory[]{new OritechJeiRecipeCategory(type, block, registration.getJeiHelpers().getGuiHelper(), isGenerator, slots, assignments)});
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        this.registerRecipe(registration, RecipeContent.PULVERIZER);
        this.registerRecipe(registration, RecipeContent.GRINDER);
        this.registerRecipe(registration, RecipeContent.ASSEMBLER);
        this.registerRecipe(registration, RecipeContent.FOUNDRY);
        this.registerRecipe(registration, RecipeContent.REFINERY);
        this.registerRecipe(registration, RecipeContent.COOLER);
        this.registerRecipe(registration, RecipeContent.CENTRIFUGE);
        this.registerRecipe(registration, RecipeContent.CENTRIFUGE_FLUID);
        this.registerRecipe(registration, RecipeContent.ATOMIC_FORGE);
        this.registerRecipe(registration, RecipeContent.BIO_GENERATOR);
        this.registerRecipe(registration, RecipeContent.FUEL_GENERATOR);
        this.registerRecipe(registration, RecipeContent.LAVA_GENERATOR);
        this.registerRecipe(registration, RecipeContent.STEAM_ENGINE);
        this.registerRecipe(registration, RecipeContent.PARTICLE_COLLISION);
        this.registerRecipe(registration, RecipeContent.LASER);
        this.registerRecipe(registration, RecipeContent.REACTOR);
    }

    public void registerRecipe(IRecipeRegistration registration, OritechRecipeType type) {
        ClientLevel world = Minecraft.getInstance().level;
        List<OritechRecipe> data = world.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)type).stream().map(RecipeHolder::value).toList();
        registration.addRecipes(RecipeType.create((String)type.getIdentifier().getNamespace(), (String)type.getIdentifier().getPath(), OritechRecipe.class), data);
    }

    public void registerRecipeCatalysts(@NotNull IRecipeCatalystRegistration registration) {
        this.registerCatalyst(registration, RecipeContent.PULVERIZER, BlockContent.PULVERIZER_BLOCK);
        this.registerCatalyst(registration, RecipeContent.GRINDER, BlockContent.FRAGMENT_FORGE_BLOCK);
        this.registerCatalyst(registration, RecipeContent.ASSEMBLER, BlockContent.ASSEMBLER_BLOCK);
        this.registerCatalyst(registration, RecipeContent.FOUNDRY, BlockContent.FOUNDRY_BLOCK);
        this.registerCatalyst(registration, RecipeContent.REFINERY, BlockContent.REFINERY_BLOCK);
        this.registerCatalyst(registration, RecipeContent.COOLER, BlockContent.COOLER_BLOCK);
        this.registerCatalyst(registration, RecipeContent.CENTRIFUGE, BlockContent.CENTRIFUGE_BLOCK);
        this.registerCatalyst(registration, RecipeContent.CENTRIFUGE_FLUID, BlockContent.CENTRIFUGE_BLOCK);
        this.registerCatalyst(registration, RecipeContent.ATOMIC_FORGE, BlockContent.ATOMIC_FORGE_BLOCK);
        this.registerCatalyst(registration, RecipeContent.BIO_GENERATOR, BlockContent.BIO_GENERATOR_BLOCK);
        this.registerCatalyst(registration, RecipeContent.FUEL_GENERATOR, BlockContent.FUEL_GENERATOR_BLOCK);
        this.registerCatalyst(registration, RecipeContent.LAVA_GENERATOR, BlockContent.LAVA_GENERATOR_BLOCK);
        this.registerCatalyst(registration, RecipeContent.STEAM_ENGINE, BlockContent.STEAM_ENGINE_BLOCK);
        this.registerCatalyst(registration, RecipeContent.PARTICLE_COLLISION, BlockContent.ACCELERATOR_CONTROLLER);
        this.registerCatalyst(registration, RecipeContent.LASER, BlockContent.LASER_ARM_BLOCK);
        this.registerCatalyst(registration, RecipeContent.REACTOR, BlockContent.REACTOR_CONTROLLER);
    }

    private void registerCatalyst(IRecipeCatalystRegistration registration, OritechRecipeType type, Block block) {
        registration.addRecipeCatalyst((ItemLike)block, new RecipeType[]{RecipeType.create((String)type.getIdentifier().getNamespace(), (String)type.getIdentifier().getPath(), OritechRecipe.class)});
    }

    public void registerGuiHandlers(@NotNull IGuiHandlerRegistration registration) {
        super.registerGuiHandlers(registration);
        registration.addGenericGuiContainerHandler(BasicMachineScreen.class, (IGuiContainerHandler)new JeiExclusionZoneHandler());
        registration.addGenericGuiContainerHandler(ReactorScreen.class, (IGuiContainerHandler)new JeiExclusionZoneHandler());
        registration.addGenericGuiContainerHandler(PlayerModifierScreen.class, (IGuiContainerHandler)new JeiExclusionZoneHandler());
        registration.addGhostIngredientHandler(ItemFilterScreen.class, (IGhostIngredientHandler)new JeiItemFilterGhostHandler());
    }
}

