/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import rearth.oritech.block.base.block.FrameInteractionBlock;
import rearth.oritech.block.base.entity.FrameInteractionBlockEntity;
import rearth.oritech.block.entity.interaction.DestroyerBlockEntity;
import rearth.oritech.client.renderers.LaserArmRenderer;
import rearth.oritech.init.BlockContent;

public class MachineGantryRenderer
implements BlockEntityRenderer<FrameInteractionBlockEntity> {
    private static final BlockState renderedBeam = BlockContent.FRAME_GANTRY_ARM.defaultBlockState();
    private static final float BEAM_DEPTH = 0.1875f;
    private static final RandomSource renderRandom = RandomSource.create((long)100L);

    public int getViewDistance() {
        return 128;
    }

    public boolean shouldRenderOffScreen(FrameInteractionBlockEntity blockEntity) {
        return true;
    }

    public void render(FrameInteractionBlockEntity entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        BlockState state = entity.getBlockState();
        if (!((Boolean)state.getValue((Property)FrameInteractionBlock.HAS_FRAME)).booleanValue() || entity.getAreaMin() == null || entity.getLastTarget() == null) {
            return;
        }
        BlockPos currentTarget = entity.getCurrentTarget();
        Vec3 renderedPosition = Vec3.atLowerCornerOf((Vec3i)currentTarget);
        Vec3 movingOffset = new Vec3(0.0, 0.0, 0.0);
        if (entity.isMoving()) {
            Vec3 lastPosition = Vec3.atLowerCornerOf((Vec3i)entity.getLastTarget());
            float progress = (float)entity.getCurrentProgress() / entity.getMoveTime();
            progress = Math.min(progress, 1.0f);
            Vec3 offset = renderedPosition.subtract(lastPosition);
            renderedPosition = lastPosition.add(offset.scale((double)progress));
        } else {
            double offsetY = (double)renderRandom.nextFloat() * 0.012 - 0.004;
            movingOffset = new Vec3(0.0, offsetY, 0.0);
        }
        entity.lastRenderedPosition = renderedPosition = LaserArmRenderer.lerp(entity.lastRenderedPosition, renderedPosition, 0.04f);
        Vec3 targetOffset = renderedPosition.subtract(Vec3.atLowerCornerOf((Vec3i)entity.getBlockPos())).add(movingOffset);
        matrices.pushPose();
        matrices.translate(targetOffset.x(), targetOffset.y(), targetOffset.z());
        BlockPos pos = entity.getCurrentTarget();
        int lightAtHead = LevelRenderer.getLightColor((BlockAndTintGetter)entity.getLevel(), (BlockPos)currentTarget);
        BlockRenderDispatcher renderer = Minecraft.getInstance().getBlockRenderer();
        renderer.renderSingleBlock(entity.getMachineHead(), matrices, vertexConsumers, lightAtHead, overlay);
        matrices.popPose();
        float length = (float)(entity.getAreaMax().getX() - entity.getAreaMin().getX() + 2) - 0.375f;
        Vec3 target = new Vec3((double)entity.getAreaMin().getX() - 0.5 + 0.1875, renderedPosition.y, renderedPosition.z).subtract(Vec3.atLowerCornerOf((Vec3i)entity.getBlockPos()));
        matrices.pushPose();
        matrices.translate(target.x(), target.y(), target.z());
        matrices.scale(length, 1.0f, 1.0f);
        renderer.renderSingleBlock(renderedBeam, matrices, vertexConsumers, lightAtHead, overlay);
        matrices.popPose();
        ItemStack renderedItem = entity.getToolheadAdditionalRender();
        if (renderedItem != null) {
            matrices.pushPose();
            matrices.translate(targetOffset.x() + 0.4, targetOffset.y(), targetOffset.z() + 0.4);
            matrices.mulPose(Axis.YP.rotationDegrees(30.0f));
            Minecraft.getInstance().getItemRenderer().renderStatic(renderedItem, ItemDisplayContext.FIRST_PERSON_RIGHT_HAND, light, OverlayTexture.NO_OVERLAY, matrices, vertexConsumers, entity.getLevel(), 0);
            matrices.popPose();
        }
        if (entity instanceof DestroyerBlockEntity) {
            DestroyerBlockEntity destroyerBlock = (DestroyerBlockEntity)entity;
            if (destroyerBlock.range > 1) {
                float beamHeight = (float)(pos.getY() - destroyerBlock.quarryTarget.getY()) - 1.3f;
                BlockState beamInner = BlockContent.QUARRY_BEAM_INNER.defaultBlockState();
                BlockState beamFrame = BlockContent.QUARRY_BEAM_TARGET.defaultBlockState();
                BlockState beamRing = BlockContent.QUARRY_BEAM_RING.defaultBlockState();
                Vec3 offset = targetOffset.add(0.0, -1.0, 0.0);
                matrices.pushPose();
                matrices.translate(offset.x(), offset.y() - (double)beamHeight + 1.0, offset.z());
                matrices.scale(1.0f, beamHeight, 1.0f);
                matrices.translate(0.5, 0.0, 0.5);
                Quaternionf rotation = new Quaternionf(new AxisAngle4f((float)entity.getLevel().getGameTime() / 3.0f % 360.0f, 0.0f, 1.0f, 0.0f));
                matrices.mulPose(rotation);
                matrices.translate(-0.5, 0.0, -0.5);
                renderer.renderSingleBlock(beamInner, matrices, vertexConsumers, lightAtHead, overlay);
                matrices.popPose();
                matrices.pushPose();
                double ringHeight = Math.sin(((float)entity.getLevel().getGameTime() + tickDelta) / 4.0f);
                double heightOffset = (double)beamHeight * 0.5 * ringHeight + (double)beamHeight * 0.5;
                matrices.translate(offset.x(), offset.y() - heightOffset + 1.0, offset.z());
                renderer.renderSingleBlock(beamRing, matrices, vertexConsumers, lightAtHead, overlay);
                matrices.popPose();
            }
        }
    }
}

