/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.blocks.accelerator;

import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.blocks.accelerator.AcceleratorPassthroughBlock;
import rearth.oritech.block.entity.accelerator.AcceleratorParticleLogic;

public class AcceleratorRingBlock
extends AcceleratorPassthroughBlock {
    public static final IntegerProperty BENT = IntegerProperty.create((String)"bent", (int)0, (int)2);
    public static final IntegerProperty REDSTONE_STATE = IntegerProperty.create((String)"redstone_state", (int)0, (int)3);

    public AcceleratorRingBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BENT, (Comparable)Integer.valueOf(0))).setValue((Property)REDSTONE_STATE, (Comparable)Integer.valueOf(3)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BENT, REDSTONE_STATE});
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)Objects.requireNonNull(super.getStateForPlacement(ctx)).setValue((Property)BENT, (Comparable)Integer.valueOf(0))).setValue((Property)REDSTONE_STATE, (Comparable)Integer.valueOf(3));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);
    }

    protected boolean isSignalSource(BlockState state) {
        return true;
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        super.neighborChanged(state, world, pos, sourceBlock, sourcePos, notify);
        if (world.isClientSide) {
            return;
        }
        boolean isPowered = world.hasNeighborSignal(pos);
        Integer lastRedstone = (Integer)state.getValue((Property)REDSTONE_STATE);
        Integer lastBent = (Integer)state.getValue((Property)BENT);
        if (lastBent == 0 && lastRedstone == 3) {
            return;
        }
        if (isPowered && (lastRedstone == 0 || lastRedstone == 3)) {
            world.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)REDSTONE_STATE, (Comparable)lastBent)).setValue((Property)BENT, (Comparable)Integer.valueOf(0)), 2, 1);
            AcceleratorParticleLogic.resetCachedGate(pos);
        } else if (!isPowered && lastRedstone != 3 && lastRedstone != 0) {
            world.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)REDSTONE_STATE, (Comparable)Integer.valueOf(0))).setValue((Property)BENT, (Comparable)lastRedstone), 2, 1);
            AcceleratorParticleLogic.resetCachedGate(pos);
        }
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        int newBent = ((Integer)state.getValue((Property)BENT) + 1) % 3;
        world.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)BENT, (Comparable)Integer.valueOf(newBent))).setValue((Property)REDSTONE_STATE, (Comparable)Integer.valueOf(3)));
        AcceleratorParticleLogic.resetCachedGate(pos);
        return InteractionResult.SUCCESS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag options) {
        boolean showExtra = Screen.hasControlDown();
        if (!showExtra) {
            tooltip.add((Component)Component.translatable((String)"tooltip.oritech.item_extra_info").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.oritech.accelerator_ring").withStyle(ChatFormatting.GRAY));
        }
    }
}

