/*
 * Decompiled with CFR 0.152.
 */
package net.azurune.runiclib.core.mixin.server;

import java.util.Map;
import net.azurune.runiclib.common.effect.TickEffectImmuneEffect;
import net.azurune.runiclib.common.util.IMobEffectInstance;
import net.azurune.runiclib.core.init.RLDamageTypes;
import net.azurune.runiclib.core.init.RLTags;
import net.azurune.runiclib.core.register.RLMobEffects;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.InstantenousMobEffect;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityEffectsMixin {
    @Final
    @Shadow
    private Map<MobEffect, MobEffectInstance> activeEffects;
    LivingEntity living = (LivingEntity)this;

    @Shadow
    public abstract MobEffectInstance getEffect(Holder<MobEffect> var1);

    @Inject(at={@At(value="HEAD")}, method={"tickEffects"})
    public void runiclib$tickEffects(CallbackInfo ci) {
        for (MobEffectInstance statusEffect : this.activeEffects.values()) {
            if (!(statusEffect.getEffect() instanceof InstantenousMobEffect && statusEffect.getEffect().is(RLTags.EffectTags.CHRONOS_BLACKLISTED) && statusEffect.getEffect() instanceof TickEffectImmuneEffect && statusEffect.getEffect() == RLMobEffects.CHRONOS || !(statusEffect instanceof IMobEffectInstance))) {
                IMobEffectInstance effect = (IMobEffectInstance)statusEffect;
                effect.setEntity((LivingEntity)this);
            }
            if (statusEffect.getEffect() == RLMobEffects.CHRONOS && this.activeEffects.values().size() > 2) {
                this.living.forceAddEffect(new MobEffectInstance(RLMobEffects.CHRONOS, statusEffect.getDuration() - (this.activeEffects.values().size() - 2), 0), (Entity)this.living);
            }
            if (!this.living.hasEffect(RLMobEffects.TEMPUS)) continue;
            int tempusAmplifier = this.activeEffects.get(RLMobEffects.TEMPUS).getAmplifier();
            if (!this.living.hasEffect(RLMobEffects.CHRONOS)) {
                if (statusEffect.getEffect() == RLMobEffects.TEMPUS || statusEffect.getEffect().is(RLTags.EffectTags.TEMPUS_BLACKLISTED)) continue;
                this.living.forceAddEffect(new MobEffectInstance(statusEffect.getEffect(), statusEffect.getDuration() - (tempusAmplifier + 1), 0), (Entity)this.living);
                continue;
            }
            if (!this.living.hasEffect(RLMobEffects.CHRONOS) || statusEffect.getEffect() != RLMobEffects.CHRONOS) continue;
            this.living.forceAddEffect(new MobEffectInstance(statusEffect.getEffect(), statusEffect.getDuration() - (tempusAmplifier + 1), 0), (Entity)this.living);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"canStandOnFluid"}, cancellable=true)
    public void runiclib$canStandOnFluid(FluidState state, CallbackInfoReturnable<Boolean> cir) {
        if (!this.living.isCrouching()) {
            if ((state.getType() == Fluids.WATER || state.getType() == Fluids.FLOWING_WATER) && this.living != null && this.living.hasEffect(RLMobEffects.WATER_WALKING)) {
                cir.setReturnValue((Object)true);
            }
            if ((state.getType() == Fluids.LAVA || state.getType() == Fluids.FLOWING_LAVA) && this.living != null && this.living.hasEffect(RLMobEffects.LAVA_WALKING)) {
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"heal"}, cancellable=true)
    public void runiclib$heal(float amount, CallbackInfo ci) {
        if (this.living.hasEffect(RLMobEffects.BLEEDING)) {
            ci.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"hurt"}, cancellable=true)
    public void runiclib$hurt(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        Entity attacker = source.getEntity();
        if (source.is(DamageTypeTags.IS_FIRE) && (this.living.hasEffect(RLMobEffects.PYROMANIAC) || this.living.hasEffect(RLMobEffects.TRAIL_BLAZING))) {
            cir.setReturnValue((Object)false);
        }
        if (this.living.hasEffect(RLMobEffects.BURNING_THORNS) && attacker != null) {
            attacker.setRemainingFireTicks(100 + this.getEffect(RLMobEffects.BURNING_THORNS).getAmplifier());
        }
        if (this.living.hasEffect(RLMobEffects.RETALIATION) && attacker != null) {
            DamageSource damagesource = new DamageSource((Holder)attacker.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(RLDamageTypes.RETALIATION));
            attacker.hurt(damagesource, 1.0f + (float)(this.getEffect(RLMobEffects.RETALIATION).getAmplifier() + 1));
        }
    }

    @ModifyVariable(at=@At(value="HEAD"), method={"hurt"}, argsOnly=true)
    public float shatterSpleen(float amount) {
        if (this.living.hasEffect(RLMobEffects.SHATTERSPLEEN)) {
            return amount + amount * (0.5f * (float)this.living.getEffect(RLMobEffects.SHATTERSPLEEN).getAmplifier() + 0.5f);
        }
        return amount;
    }
}

