/*
 * Decompiled with CFR 0.152.
 */
package net.azurune.runiclib.core.library.integration;

import java.util.function.Supplier;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class ReflectionUtils {
    public static <T> T createInstance(String classPath, Object ... args) {
        try {
            Class[] argTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                argTypes[i] = args[i].getClass();
            }
            return (T)Class.forName(classPath).getConstructor(argTypes).newInstance(args);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static <T extends Block> T reflectBlock(String classPath, Supplier<T> supplier, Object ... args) {
        Block block = (Block)ReflectionUtils.createInstance(classPath, args);
        return (T)(block != null ? block : (Block)supplier.get());
    }

    public static <T extends Item> T reflectItem(String classPath, Supplier<T> supplier, Object ... args) {
        Item item = (Item)ReflectionUtils.createInstance(classPath, args);
        return (T)(item != null ? item : (Item)supplier.get());
    }

    public static <T extends MobEffect> T reflectMobEffect(String classPath, Supplier<T> supplier, Object ... args) {
        MobEffect mobEffect = (MobEffect)ReflectionUtils.createInstance(classPath, args);
        return (T)(mobEffect != null ? mobEffect : (MobEffect)supplier.get());
    }
}

