/*
 * Decompiled with CFR 0.152.
 */
package net.azurune.runiclib.common.effect;

import java.util.Optional;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.InstantenousMobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.phys.Vec3;

public class TraversalEffect
extends InstantenousMobEffect {
    public TraversalEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean applyEffectTick(LivingEntity living, int amplifier) {
        if (living instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)living;
            ServerLevel level = Optional.ofNullable(serverPlayer.getServer().getLevel(serverPlayer.getRespawnDimension())).orElse(serverPlayer.getServer().overworld());
            Vec3 pos = Vec3.atCenterOf((Vec3i)level.getSharedSpawnPos());
            if (serverPlayer.getRespawnPosition() != null && this.isPositionValid(serverPlayer)) {
                pos = Vec3.atCenterOf((Vec3i)serverPlayer.getRespawnPosition());
            }
            serverPlayer.teleportTo(pos.x, pos.y, pos.z);
            serverPlayer.playSound(SoundEvents.CHORUS_FRUIT_TELEPORT);
        }
        return true;
    }

    public boolean isPositionValid(ServerPlayer serverPlayer) {
        return serverPlayer.level().getBlockState(serverPlayer.getRespawnPosition()).getBlock() instanceof BedBlock || serverPlayer.level().getBlockState(serverPlayer.getRespawnPosition()).getBlock() instanceof RespawnAnchorBlock;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public boolean isInstantenous() {
        return true;
    }
}

