/*
 * Decompiled with CFR 0.152.
 */
package net.azurune.runiclib.common.effect;

import net.azurune.runiclib.RunicLib;
import net.azurune.runiclib.common.publicized.PublicMobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class AdrenalineEffect
extends PublicMobEffect {
    public AdrenalineEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean applyEffectTick(LivingEntity living, int amplifier) {
        float speedModifier = 1.0f - living.getHealth() / living.getMaxHealth();
        if (living.getAttribute(Attributes.MOVEMENT_SPEED) == null) {
            return false;
        }
        AttributeModifier originalModifier = living.getAttribute(Attributes.MOVEMENT_SPEED).getModifier(RunicLib.modid("adrenaline.movement_speed"));
        if (originalModifier == null) {
            return false;
        }
        AttributeModifier newAttributeModifier = new AttributeModifier(originalModifier.id(), (double)(speedModifier * ((float)amplifier + 1.0f)), originalModifier.operation());
        living.getAttribute(Attributes.MOVEMENT_SPEED).removeModifier(originalModifier.id());
        living.getAttribute(Attributes.MOVEMENT_SPEED).addTransientModifier(newAttributeModifier);
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

