/*
 * Decompiled with CFR 0.152.
 */
package net.azurune.runiclib.common.effect;

import java.util.List;
import net.azurune.runiclib.common.publicized.PublicMobEffect;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class AOEEffect
extends PublicMobEffect {
    private final Holder<MobEffect> effect;
    private final int effectTicks;
    private final int effectAmp;
    private final int cooldown;
    private final double radius;
    private final boolean grantSelf;

    public AOEEffect(Holder<MobEffect> effect, int effectTicks, int effectAmp, int cooldown, double radius, boolean grantSelf, MobEffectCategory category, int color) {
        super(category, color);
        this.effect = effect;
        this.effectTicks = effectTicks;
        this.effectAmp = effectAmp;
        this.cooldown = cooldown;
        this.radius = radius;
        this.grantSelf = grantSelf;
    }

    public boolean applyEffectTick(LivingEntity living, int amplifier) {
        Level level = living.level();
        List list = level.getEntitiesOfClass(LivingEntity.class, living.getBoundingBox().inflate(this.radius + (double)amplifier), Entity::isAlive);
        for (LivingEntity livingEntity : list) {
            if (livingEntity.isAlive() && living != livingEntity && !this.grantSelf) {
                livingEntity.addEffect(new MobEffectInstance(this.effect, this.effectTicks, this.effectAmp));
                continue;
            }
            if (!livingEntity.isAlive() || !this.grantSelf) continue;
            livingEntity.addEffect(new MobEffectInstance(this.effect, this.effectTicks, this.effectAmp));
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration % this.cooldown == 0;
    }
}

