/*
 * Decompiled with CFR 0.152.
 */
package net.azurune.runiclib.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class SaturationCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"saturation_rl").requires(source -> source.hasPermission(4))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.entity()).then(Commands.argument((String)"amount", (ArgumentType)FloatArgumentType.floatArg()).executes(SaturationCommand::execute))));
    }

    private static int execute(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Entity targetEntity = EntityArgument.getEntity(ctx, (String)"target");
        if (targetEntity instanceof ServerPlayer) {
            float amount;
            ServerPlayer player = (ServerPlayer)targetEntity;
            float currentFood = player.getFoodData().getSaturationLevel();
            float result = Math.max(0.0f, Math.min(5.0f, currentFood + (amount = FloatArgumentType.getFloat(ctx, (String)"amount"))));
            if (result == currentFood) {
                throw new SimpleCommandExceptionType((Message)Component.translatable((String)"runiclib.commands.saturation.fail")).create();
            }
            player.getFoodData().setSaturation(result);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"runiclib.commands.saturation.success", (Object[])new Object[]{Float.valueOf(amount), player.getDisplayName()}), true);
            return 1;
        }
        ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"runiclib.commands.not_player"));
        return 0;
    }
}

