/*
 * Decompiled with CFR 0.152.
 */
package net.azurune.runiclib.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class DyeGiveCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"dyegive_rl").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"suffix", (ArgumentType)StringArgumentType.string()).executes(ctx -> DyeGiveCommand.execute((CommandSourceStack)ctx.getSource(), EntityArgument.getPlayers((CommandContext)ctx, (String)"targets"), StringArgumentType.getString((CommandContext)ctx, (String)"suffix"))))));
    }

    private static int execute(CommandSourceStack ctx, Collection<ServerPlayer> targets, String suffix) {
        int totalGiven = 0;
        for (DyeColor dyeEnum : DyeColor.values()) {
            String itemName = dyeEnum.getSerializedName() + suffix;
            Item item = BuiltInRegistries.ITEM.getOptional(ResourceLocation.tryParse((String)itemName)).orElse(null);
            if (item == null) continue;
            ItemStack stack = new ItemStack((ItemLike)item);
            for (ServerPlayer player : targets) {
                boolean added = player.getInventory().add(stack.copy());
                if (!added) {
                    ItemEntity dropped = player.drop(stack.copy(), false);
                    if (dropped == null) continue;
                    dropped.setNoPickUpDelay();
                    dropped.setTarget(player.getUUID());
                    continue;
                }
                player.containerMenu.broadcastChanges();
            }
            ++totalGiven;
        }
        int finalTotalGiven = totalGiven;
        if (totalGiven == 0) {
            ctx.sendFailure((Component)Component.translatable((String)"runiclib.commands.dyegive.no_suffix"));
        } else if (targets.size() == 1) {
            ctx.sendSuccess(() -> Component.translatable((String)"runiclib.commands.dyegive.success", (Object[])new Object[]{finalTotalGiven, ((ServerPlayer)targets.iterator().next()).getDisplayName().getString()}), true);
        } else {
            ctx.sendSuccess(() -> Component.translatable((String)"runiclib.commands.dyegive.success", (Object[])new Object[]{finalTotalGiven, targets.size() + " runiclib.commands.players"}), true);
        }
        return targets.size();
    }
}

