/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.neoforge;

import java.util.List;
import net.minecraft.data.DataProvider;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.satisfy.vinery.core.Vinery;
import net.satisfy.vinery.core.registry.CompostableRegistry;
import net.satisfy.vinery.core.util.PreInit;
import net.satisfy.vinery.neoforge.core.config.VineryForgeConfig;
import net.satisfy.vinery.neoforge.core.datagen.ModAdvancementGen;
import net.satisfy.vinery.neoforge.core.registry.VineryNeoForgeVillagers;
import net.satisfy.vinery.platform.neoforge.PlatformHelperImpl;

@Mod(value="vinery")
public class VineryForge {
    public VineryForge(IEventBus modEventBus, ModContainer modContainer) {
        PlatformHelperImpl.ENTITY_TYPES.register();
        PreInit.preInit();
        Vinery.init();
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)VineryForgeConfig.COMMON_CONFIG, "vinery.toml");
        modEventBus.register(VineryForgeConfig.class);
        VineryNeoForgeVillagers.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            CompostableRegistry.registerCompostable();
            Vinery.commonSetup();
        });
    }

    private void onGatherData(GatherDataEvent event) {
        event.addProvider((DataProvider)new ModAdvancementGen(event.getGenerator().getPackOutput(), event.getLookupProvider(), event.getExistingFileHelper(), List.of(new ModAdvancementGen.MyAdvancementGenerator())));
    }
}

