/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.satisfy.vinery.core.registry.GrapeTypeRegistry;
import org.jetbrains.annotations.NotNull;

public class GrapeType
implements Comparable<GrapeType>,
StringRepresentable {
    public static final Codec<GrapeType> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.fieldOf("id").forGetter(GrapeType::getId), (App)Codec.BOOL.fieldOf("lattice").forGetter(GrapeType::isLattice), (App)Codec.BOOL.fieldOf("red").forGetter(GrapeType::isRed)).apply((Applicative)inst, GrapeType::new));
    private final String id;
    private final boolean lattice;
    private final boolean red;
    private Supplier<Item> fruit;
    private Supplier<Item> seeds;
    private Supplier<Item> bottle;

    public GrapeType(String id, boolean lattice, boolean red) {
        this(id, () -> Items.AIR, () -> Items.AIR, () -> Items.AIR, lattice, red);
    }

    private GrapeType(String id, Supplier<Item> fruit, Supplier<Item> seeds, Supplier<Item> bottle, boolean lattice, boolean red) {
        this.id = id;
        this.fruit = fruit;
        this.seeds = seeds;
        this.bottle = bottle;
        this.lattice = lattice;
        this.red = red;
    }

    public static GrapeType fromString(String id) {
        for (GrapeType type : GrapeTypeRegistry.GRAPE_TYPE_TYPES) {
            if (!type.getSerializedName().equals(id)) continue;
            return type;
        }
        return null;
    }

    @NotNull
    public String getSerializedName() {
        return this.id;
    }

    public Item getFruit() {
        return this.fruit.get();
    }

    public String getId() {
        return this.id;
    }

    public Item getSeeds() {
        return this.seeds.get();
    }

    public Item getBottle() {
        return this.bottle.get();
    }

    public boolean isLattice() {
        return this.lattice;
    }

    public boolean isRed() {
        return this.red;
    }

    public boolean isWhite() {
        return !this.red;
    }

    public void setItems(Supplier<Item> fruit, Supplier<Item> seeds, Supplier<Item> bottle) {
        this.fruit = fruit;
        this.seeds = seeds;
        this.bottle = bottle;
    }

    @Override
    public int compareTo(@NotNull GrapeType grapeType) {
        return this.id.compareTo(grapeType.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GrapeType)) {
            return false;
        }
        GrapeType grapeType = (GrapeType)o;
        return Objects.equals(this.id, grapeType.id);
    }
}

