/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.effect;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.InstantenousMobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TeleportEffect
extends InstantenousMobEffect {
    public TeleportEffect() {
        super(MobEffectCategory.BENEFICIAL, 16738740);
    }

    public void applyInstantenousEffect(@Nullable Entity source, @Nullable Entity attacker, LivingEntity target, int amplifier, double proximity) {
        this.teleport(source);
    }

    public boolean applyEffectTick(LivingEntity source, int i) {
        this.teleport((Entity)source);
        return true;
    }

    private void teleport(Entity source) {
        if (!(source instanceof Player)) {
            return;
        }
        Player player = (Player)source;
        Level world = player.level();
        Vec3 targetVec = player.position();
        Vec3 lookVec = player.getLookAngle();
        BlockPos target = null;
        for (double i = 12.0; i >= 2.0; i -= 0.5) {
            Vec3 v3d = targetVec.add(lookVec.multiply(i, i, i));
            target = new BlockPos((int)Math.round(v3d.x), (int)Math.round(v3d.y), (int)Math.round(v3d.z));
            if (!TeleportEffect.fullBlockAt(world, target) && !TeleportEffect.fullBlockAt(world, target.above())) break;
            target = null;
        }
        if (target != null) {
            if (!player.level().isClientSide) {
                Vec3 teleportVec = new Vec3((double)target.getX(), (double)target.getY(), (double)target.getZ());
                player.teleportRelative(teleportVec.x + 0.5, teleportVec.y, teleportVec.z + 0.5);
            }
            player.fallDistance = 0.0f;
            player.playSound(SoundEvents.ENDER_EYE_DEATH, 1.0f, 1.0f);
        }
    }

    private static boolean fullBlockAt(Level world, BlockPos target) {
        return Block.isShapeFullBlock((VoxelShape)world.getBlockState(target).getCollisionShape((BlockGetter)world, target));
    }

    private void oldTeleport(Player player) {
        Vec3 lookVec = player.getLookAngle();
        Vec3 teleportPos = player.position().add(lookVec.x * 30.0, lookVec.y * 30.0, lookVec.z * 30.0);
        player.teleportRelative(teleportPos.x, teleportPos.y, teleportPos.z);
    }
}

