/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.compat.rei.wine;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.satisfy.vinery.core.compat.rei.wine.FermentationBarrelDisplay;
import net.satisfy.vinery.core.registry.ObjectRegistry;
import net.satisfy.vinery.core.util.JuiceUtil;

public class FermentationBarrelCategory
implements DisplayCategory<FermentationBarrelDisplay> {
    public CategoryIdentifier<FermentationBarrelDisplay> getCategoryIdentifier() {
        return FermentationBarrelDisplay.FERMENTATION_BARREL_DISPLAY;
    }

    public Component getTitle() {
        return ((Block)ObjectRegistry.FERMENTATION_BARREL.get()).getName();
    }

    public Renderer getIcon() {
        return EntryStacks.of((ItemLike)((ItemLike)ObjectRegistry.FERMENTATION_BARREL.get()));
    }

    public List<Widget> setupDisplay(FermentationBarrelDisplay display, Rectangle bounds) {
        ArrayList widgets = Lists.newArrayList();
        Point origin = new Point(bounds.getMinX() + 10, bounds.getMinY() + 10);
        widgets.add(Widgets.createRecipeBase((Rectangle)bounds));
        int SLOT_SPACING = 18;
        int ingredientCount = display.getInputEntries().size();
        if (ingredientCount >= 1) {
            widgets.add(Widgets.createSlot((Point)new Point(origin.x + 0, origin.y + 18 + 4)).entries((Collection)display.getInputEntries().get(0)).markInput());
        }
        if (ingredientCount >= 2) {
            widgets.add(Widgets.createSlot((Point)new Point(origin.x + 18, origin.y + 18 + 4)).entries((Collection)display.getInputEntries().get(1)).markInput());
        }
        if (ingredientCount >= 3) {
            widgets.add(Widgets.createSlot((Point)new Point(origin.x + 36, origin.y + 18 + 4)).entries((Collection)display.getInputEntries().get(2)).markInput());
        }
        if (ingredientCount >= 4) {
            widgets.add(Widgets.createSlot((Point)new Point(origin.x + 54, origin.y + 18 + 4)).entries((Collection)display.getInputEntries().get(3)).markInput());
        }
        widgets.add(Widgets.createSlot((Point)new Point(origin.x, origin.y)).entry(EntryStacks.of((ItemStack)this.getJuiceItemForType(display.getJuiceType()))).disableBackground().markInput());
        widgets.add(Widgets.createLabel((Point)new Point(origin.x + 54 - 8, origin.y + 5), (Component)Component.literal((String)("Amount: " + display.getJuiceAmount()))));
        widgets.add(Widgets.createArrow((Point)new Point(origin.x + 72, origin.y + 8)).animationDurationTicks(50.0));
        widgets.add(Widgets.createResultSlotBackground((Point)new Point(bounds.getMaxX() - 26 - 10, origin.y + 8)));
        widgets.add(Widgets.createSlot((Point)new Point(bounds.getMaxX() - 26 - 10, origin.y + 8)).entries((Collection)display.getOutputEntries().get(0)).disableBackground().markOutput());
        return widgets;
    }

    private ItemStack getJuiceItemForType(String juiceType) {
        Optional<ItemStack> juiceItem = JuiceUtil.RED_JUICE_TAGS.entrySet().stream().filter(entry -> juiceType.equals("red_" + (String)entry.getValue())).flatMap(entry -> BuiltInRegistries.ITEM.getTag((TagKey)entry.getKey()).stream()).flatMap(HolderSet.ListBacked::stream).findFirst().map(ItemStack::new);
        if (juiceItem.isPresent()) {
            return juiceItem.get();
        }
        juiceItem = JuiceUtil.WHITE_JUICE_TAGS.entrySet().stream().filter(entry -> juiceType.equals("white_" + (String)entry.getValue())).flatMap(entry -> BuiltInRegistries.ITEM.getTag((TagKey)entry.getKey()).stream()).flatMap(HolderSet.ListBacked::stream).findFirst().map(ItemStack::new);
        if (juiceItem.isPresent()) {
            return juiceItem.get();
        }
        juiceItem = JuiceUtil.APPLE_JUICES.entrySet().stream().filter(entry -> juiceType.equals(entry.getValue())).map(entry -> new ItemStack((ItemLike)entry.getKey())).findFirst();
        return juiceItem.orElse(ItemStack.EMPTY);
    }
}

