/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.compat.jei.category;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.satisfy.vinery.core.recipe.ApplePressMashingRecipe;
import net.satisfy.vinery.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;

public class ApplePressMashingCategory
implements IRecipeCategory<ApplePressMashingRecipe> {
    public static final RecipeType<ApplePressMashingRecipe> APPLE_PRESS_MASHING_TYPE = RecipeType.create((String)"vinery", (String)"apple_press_mashing", ApplePressMashingRecipe.class);
    private static final int BACKGROUND_WIDTH = 160;
    private static final int BACKGROUND_HEIGHT = 70;
    private static final int X_OFFSET = 10;
    private static final int Y_OFFSET = 10;
    private final IDrawable background;
    private final IDrawable icon;
    private final Component title;

    public ApplePressMashingCategory(IGuiHelper helper) {
        ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"vinery", (String)"textures/gui/apple_press_gui.png");
        this.background = helper.createDrawable(texture, 10, 10, 160, 70);
        ItemStack pressStack = new ItemStack((ItemLike)ObjectRegistry.APPLE_PRESS.get());
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)pressStack);
        this.title = ((Block)ObjectRegistry.APPLE_PRESS.get()).getName();
    }

    @NotNull
    public RecipeType<ApplePressMashingRecipe> getRecipeType() {
        return APPLE_PRESS_MASHING_TYPE;
    }

    @NotNull
    public Component getTitle() {
        return this.title;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ApplePressMashingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 34, 24).addIngredients((Ingredient)recipe.getIngredients().get(0));
        assert (Minecraft.getInstance().level != null);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 91, 40).addItemStack(recipe.getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()));
    }
}

