/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.satisfy.vinery.core.registry.EntityTypeRegistry;
import net.satisfy.vinery.core.registry.GrapeTypeRegistry;
import net.satisfy.vinery.core.util.GrapeType;
import org.jetbrains.annotations.NotNull;

public class LatticeBlockEntity
extends BlockEntity {
    private int age = 0;
    private GrapeType grape = GrapeTypeRegistry.NONE;
    private boolean showHanging;
    private boolean initialized;

    public LatticeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.LATTICE.get(), pos, state);
    }

    public boolean shouldShowHanging() {
        return this.showHanging;
    }

    public void setAge(int age) {
        this.age = age;
        this.setChanged();
        this.sync();
    }

    public int getAge() {
        return this.age;
    }

    public void setGrapeType(GrapeType grape) {
        this.grape = grape;
        if (!this.initialized && this.level != null) {
            this.showHanging = this.level.random.nextFloat() < 0.15f;
            this.initialized = true;
        }
        this.setChanged();
        this.sync();
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.age = tag.getInt("Age");
        this.grape = GrapeType.fromString(tag.getString("Grape"));
        this.showHanging = tag.getBoolean("ShowHanging");
        this.initialized = true;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        tag.putInt("Age", this.age);
        tag.putString("Grape", this.grape.getSerializedName());
        tag.putBoolean("ShowHanging", this.showHanging);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, provider);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    private void sync() {
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }
}

