/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.camping.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.satisfy.camping.core.world.item.MarshmallowOnAStickItem;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemInHandRenderer.class})
public abstract class NeoForgeItemInHandRendererMixin {
    @Shadow
    protected abstract void applyItemArmTransform(PoseStack var1, HumanoidArm var2, float var3);

    @Shadow
    protected abstract void applyItemArmAttackTransform(PoseStack var1, HumanoidArm var2, float var3);

    @Shadow
    public abstract void renderItem(LivingEntity var1, ItemStack var2, ItemDisplayContext var3, boolean var4, PoseStack var5, MultiBufferSource var6, int var7);

    @Inject(method={"renderArmWithItem(Lnet/minecraft/client/player/AbstractClientPlayer;FFLnet/minecraft/world/InteractionHand;FLnet/minecraft/world/item/ItemStack;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectMarshmallowUseAnim(AbstractClientPlayer player, float partialTicks, float pitch, InteractionHand hand, float swingProgress, ItemStack stack, float equipProgress, PoseStack matrices, MultiBufferSource bufferSource, int light, CallbackInfo ci) {
        if (!player.isUsingItem()) {
            return;
        }
        ItemStack used = player.getUseItem();
        if (!(used.getItem() instanceof MarshmallowOnAStickItem)) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        HitResult hitResult = mc.hitResult;
        if (!(hitResult instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult bhr = (BlockHitResult)hitResult;
        BlockState state = player.level().getBlockState(bhr.getBlockPos());
        if (!(state.getBlock() instanceof CampfireBlock)) {
            return;
        }
        if (state.hasProperty((Property)CampfireBlock.LIT) && !((Boolean)state.getValue((Property)CampfireBlock.LIT)).booleanValue()) {
            return;
        }
        float usedTicks = (float)(used.getUseDuration((LivingEntity)player) - player.getUseItemRemainingTicks()) + partialTicks;
        float main = usedTicks * 0.2617994f;
        float wiggle = Mth.sin((float)main) * 0.06f;
        float bounce = Mth.sin((float)(main * 0.5f)) * 0.03f;
        HumanoidArm arm = hand == InteractionHand.MAIN_HAND ? player.getMainArm() : player.getMainArm().getOpposite();
        matrices.pushPose();
        this.applyItemArmTransform(matrices, arm, 1.0f);
        this.applyItemArmAttackTransform(matrices, arm, swingProgress);
        matrices.translate(0.06f + wiggle, 0.3f + bounce, -0.32f);
        matrices.mulPose(new Quaternionf(new AxisAngle4f((float)Math.toRadians(-10.0), 1.0f, 0.0f, 0.0f)));
        matrices.mulPose(new Quaternionf(new AxisAngle4f((float)Math.toRadians(12.0), 0.0f, 1.0f, 0.0f)));
        matrices.scale(1.4f, 1.4f, 1.4f);
        this.renderItem((LivingEntity)player, stack, hand == InteractionHand.MAIN_HAND ? ItemDisplayContext.FIRST_PERSON_RIGHT_HAND : ItemDisplayContext.FIRST_PERSON_LEFT_HAND, hand == InteractionHand.OFF_HAND, matrices, bufferSource, light);
        matrices.popPose();
        ci.cancel();
    }
}

