/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.camping.core.world.recipe;

import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.satisfy.camping.core.registry.NeoForgeCampingRecipes;
import net.satisfy.camping.core.world.item.BackpackBlockItem;
import net.satisfy.camping.core.world.recipe.IWrapperRecipe;
import net.satisfy.camping.core.world.recipe.RecipeWrapperSerializer;
import org.jetbrains.annotations.NotNull;

public class ForgeBackpackUpgradeRecipe
implements CraftingRecipe,
IWrapperRecipe<ShapedRecipe> {
    private final ShapedRecipe compose;

    public ForgeBackpackUpgradeRecipe(ShapedRecipe compose) {
        this.compose = compose;
    }

    @Override
    public ShapedRecipe getCompose() {
        return this.compose;
    }

    @NotNull
    public String getGroup() {
        return this.compose.getGroup();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return NeoForgeCampingRecipes.BACKPACK_UPGRADE;
    }

    public boolean showNotification() {
        return this.compose.showNotification();
    }

    public boolean canCraftInDimensions(int w, int h) {
        return this.compose.canCraftInDimensions(w, h);
    }

    public boolean matches(CraftingInput input, Level level) {
        return this.compose.matches(input, level);
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.compose.getResultItem(provider);
    }

    public CraftingBookCategory category() {
        return this.compose.category();
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.compose.getIngredients();
    }

    public boolean isSpecial() {
        return true;
    }

    private Optional<ItemStack> getBackpack(CraftingInput input) {
        for (int i = 0; i < input.size(); ++i) {
            ItemStack s = input.getItem(i);
            if (!(s.getItem() instanceof BackpackBlockItem)) continue;
            return Optional.of(s);
        }
        return Optional.empty();
    }

    @NotNull
    public ItemStack assemble(CraftingInput input, HolderLookup.Provider provider) {
        ItemStack out = this.compose.assemble(input, provider);
        this.getBackpack(input).ifPresent(src -> {
            CustomData cd = (CustomData)src.get(DataComponents.CUSTOM_DATA);
            if (cd != null) {
                out.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)cd.copyTag()));
            }
        });
        Item item = out.getItem();
        if (item instanceof BackpackBlockItem) {
            BackpackBlockItem b = (BackpackBlockItem)item;
            CustomData cd = (CustomData)out.get(DataComponents.CUSTOM_DATA);
            CompoundTag tag = cd != null ? cd.copyTag() : new CompoundTag();
            tag.putInt("slots", b.getNumberOfSlots());
            tag.putInt("upgradeSlots", b.getNumberOfUpgradeSlots());
            out.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        }
        return out;
    }

    public static class Serializer
    extends RecipeWrapperSerializer<ShapedRecipe, ForgeBackpackUpgradeRecipe> {
        public Serializer() {
            super(ForgeBackpackUpgradeRecipe::new, RecipeSerializer.SHAPED_RECIPE);
        }
    }
}

