/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.camping.core.world.inventory;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.satisfy.camping.core.world.BackpackContainer;
import net.satisfy.camping.core.world.inventory.BackpackData;
import net.satisfy.camping.core.world.inventory.BackpackScreenHandler;
import net.satisfy.camping.platform.Services;
import org.jetbrains.annotations.NotNull;

public class NeoForgeBackpackScreenHandler
extends BackpackScreenHandler {
    public NeoForgeBackpackScreenHandler(int id, Inventory inv, BackpackContainer container, BlockPos pos) {
        super(id, inv, container, pos);
    }

    @Override
    public boolean stillValid(@NotNull Player player) {
        return Services.PLATFORM.getEquippedBackpack(player) != null && !Services.PLATFORM.getEquippedBackpack(player).isEmpty();
    }

    @Override
    public void removed(@NotNull Player player) {
        super.removed(player);
        this.container.stopOpen(player);
        ItemStack equipped = Services.PLATFORM.getEquippedBackpack(player);
        if (equipped != null && !equipped.isEmpty()) {
            BackpackData.write(equipped, this.container.getItems());
        }
        if (!player.level().isClientSide) {
            this.container.setChanged();
        }
    }
}

