/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.camping.core.world.inventory;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.satisfy.camping.core.registry.CampingScreenHandlers;
import net.satisfy.camping.core.registry.CampingTags;
import net.satisfy.camping.core.world.BackpackContainer;
import net.satisfy.camping.core.world.block.BackpackBlock;
import org.jetbrains.annotations.NotNull;

public class BackpackScreenHandler
extends AbstractContainerMenu {
    final BackpackContainer container;
    private final Player player;
    private final BlockPos blockPos;
    private final boolean portable;

    public BackpackScreenHandler(int syncId, Inventory playerInventory, BackpackContainer container, BlockPos blockPos) {
        super(CampingScreenHandlers.BACKPACK, syncId);
        int j;
        BackpackScreenHandler.checkContainerSize((Container)container, (int)24);
        this.container = container;
        this.player = playerInventory.player;
        this.blockPos = blockPos;
        this.portable = blockPos.equals((Object)BlockPos.ZERO);
        container.startOpen(playerInventory.player);
        for (int j2 = 0; j2 < 3; ++j2) {
            for (int k = 0; k < 8; ++k) {
                this.addSlot(new Slot(this, container, k + j2 * 8, 17 + k * 18, 12 + j2 * 18){

                    public boolean mayPlace(@NotNull ItemStack stack) {
                        return !stack.is(CampingTags.BACKPACK_BLACKLIST);
                    }
                });
            }
        }
        int oy = 1;
        for (j = 0; j < 3; ++j) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new Slot((Container)playerInventory, k + j * 9 + 9, 8 + k * 18, 85 + j * 18 + oy));
            }
        }
        for (j = 0; j < 9; ++j) {
            this.addSlot(new Slot((Container)playerInventory, j, 8 + j * 18, 143 + oy));
        }
    }

    public BackpackScreenHandler(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, new BackpackContainer((NonNullList<ItemStack>)NonNullList.withSize((int)24, (Object)ItemStack.EMPTY)), BlockPos.ZERO);
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int i) {
        if (i < 0 || i >= this.slots.size()) {
            return ItemStack.EMPTY;
        }
        ItemStack ret = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(i);
        if (!slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack in = slot.getItem();
        ret = in.copy();
        if (i < 24 ? !this.moveItemStackTo(in, 24, this.slots.size(), true) : !this.moveItemStackTo(in, 0, 24, false)) {
            return ItemStack.EMPTY;
        }
        if (in.isEmpty()) {
            slot.setByPlayer(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        if (in.getCount() == ret.getCount()) {
            return ItemStack.EMPTY;
        }
        slot.onTake(player, in);
        return ret;
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        if (!this.player.isAlive()) {
            this.player.closeContainer();
            return;
        }
        if (!this.player.level().isClientSide) {
            this.container.setChanged();
            if (!this.portable && this.player.distanceToSqr((double)this.blockPos.getX() + 0.5, (double)this.blockPos.getY() + 0.5, (double)this.blockPos.getZ() + 0.5) > 64.0) {
                this.player.closeContainer();
            }
        }
    }

    public void removed(@NotNull Player player) {
        super.removed(player);
        this.container.stopOpen(player);
        if (!player.level().isClientSide) {
            this.container.setChanged();
        }
    }

    public boolean stillValid(@NotNull Player player) {
        if (this.portable) {
            return true;
        }
        BlockState s = player.level().getBlockState(this.blockPos);
        Block b = s.getBlock();
        boolean ok = b instanceof BackpackBlock && player.level().getBlockEntity(this.blockPos) != null && !Objects.requireNonNull(player.level().getBlockEntity(this.blockPos)).isRemoved();
        return this.container.stillValid(player) && (ok || b == Blocks.AIR && player.distanceToSqr((double)this.blockPos.getX(), (double)this.blockPos.getY(), (double)this.blockPos.getZ()) < 2.0);
    }
}

