/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.camping.core.world.inventory;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.ItemContainerContents;

public final class BackpackData {
    public static NonNullList<ItemStack> read(ItemStack stack) {
        NonNullList out = NonNullList.withSize((int)24, (Object)ItemStack.EMPTY);
        ((ItemContainerContents)stack.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).copyInto(out);
        return out;
    }

    public static void write(ItemStack stack, NonNullList<ItemStack> items) {
        stack.remove(DataComponents.BLOCK_ENTITY_DATA);
        if (BackpackData.allEmpty(items)) {
            stack.remove(DataComponents.CONTAINER);
        } else {
            stack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(items));
        }
    }

    public static void migrateFromBlockEntityData(ItemStack stack, RegistryAccess access) {
        CustomData be = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
        if (be == null) {
            return;
        }
        CompoundTag tag = be.copyTag();
        NonNullList out = NonNullList.withSize((int)24, (Object)ItemStack.EMPTY);
        if (tag.contains("Items", 9)) {
            ContainerHelper.loadAllItems((CompoundTag)tag, (NonNullList)out, (HolderLookup.Provider)access);
        }
        BackpackData.write(stack, (NonNullList<ItemStack>)out);
    }

    private static boolean allEmpty(NonNullList<ItemStack> items) {
        for (ItemStack s : items) {
            if (s.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private BackpackData() {
    }
}

