/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.camping.core.world.block;

import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.ParametersAreNullableByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.camping.core.util.CampingUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@ParametersAreNullableByDefault
public class SleepingBagBlock
extends BedBlock {
    public static final BooleanProperty OCCUPIED = BlockStateProperties.OCCUPIED;
    public static final BooleanProperty CAN_DROP = BlockStateProperties.CONDITIONAL;
    protected static final VoxelShape SLEEPING_BAG_SHAPE = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.25, (double)1.0);

    public SleepingBagBlock(DyeColor dyeColor) {
        super(dyeColor, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_WOOL).pushReaction(PushReaction.IGNORE).instabreak().mapColor(DyeColor.WHITE).forceSolidOn());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)PART, (Comparable)BedPart.FOOT)).setValue((Property)OCCUPIED, (Comparable)Boolean.FALSE)).setValue((Property)CAN_DROP, (Comparable)Boolean.TRUE));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, PART, OCCUPIED, CAN_DROP});
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return state.getValue((Property)PART) == BedPart.HEAD ? CampingUtil.rotateShape(Direction.NORTH, (Direction)state.getValue((Property)FACING), SLEEPING_BAG_SHAPE) : SLEEPING_BAG_SHAPE;
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    private static Direction getNeighbourDirection(BedPart part, Direction direction) {
        return part == BedPart.FOOT ? direction : direction.getOpposite();
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState newState, LevelAccessor accessor, BlockPos pos, BlockPos newPos) {
        if (direction == SleepingBagBlock.getNeighbourDirection((BedPart)state.getValue((Property)PART), (Direction)state.getValue((Property)FACING))) {
            return newState.is((Block)this) && newState.getValue((Property)PART) != state.getValue((Property)PART) ? (BlockState)state.setValue((Property)OCCUPIED, (Comparable)((Boolean)newState.getValue((Property)OCCUPIED))) : Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, direction, newState, accessor, pos, newPos);
    }

    private static void bounceUp(Entity entity) {
        Vec3 v = entity.getDeltaMovement();
        if (v.y < 0.0) {
            double m = entity instanceof LivingEntity ? 1.0 : 0.8;
            entity.setDeltaMovement(v.x, -v.y * (double)0.66f * m, v.z);
        }
    }

    public void updateEntityAfterFallOn(BlockGetter getter, Entity entity) {
        if (entity.isSuppressingBounce()) {
            super.updateEntityAfterFallOn(getter, entity);
        } else {
            SleepingBagBlock.bounceUp(entity);
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction dir = context.getHorizontalDirection();
        BlockPos pos = context.getClickedPos();
        BlockPos head = pos.relative(dir);
        return context.getLevel().getBlockState(head).canBeReplaced(context) ? (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)dir) : null;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity living, ItemStack stack) {
        super.setPlacedBy(level, pos, state, living, stack);
        if (!level.isClientSide) {
            BlockPos headPos = pos.relative((Direction)state.getValue((Property)FACING));
            level.setBlock(headPos, (BlockState)state.setValue((Property)PART, (Comparable)BedPart.HEAD), 3);
            level.blockUpdated(pos, Blocks.AIR);
            state.updateNeighbourShapes((LevelAccessor)level, pos, 3);
        }
    }

    public long getSeed(BlockState state, BlockPos pos) {
        BlockPos p = pos.relative((Direction)state.getValue((Property)FACING), state.getValue((Property)PART) == BedPart.HEAD ? 0 : 1);
        return Mth.getSeed((int)p.getX(), (int)pos.getY(), (int)p.getZ());
    }

    @NotNull
    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        if (!((Boolean)state.getValue((Property)CAN_DROP)).booleanValue()) {
            return List.of();
        }
        return super.getDrops(state, builder);
    }

    private boolean kickVillagerOutOfBed(Level level, BlockPos pos) {
        List villagers = level.getEntitiesOfClass(Villager.class, new AABB(pos), LivingEntity::isSleeping);
        if (villagers.isEmpty()) {
            return false;
        }
        ((Villager)villagers.get(0)).stopSleeping();
        return true;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (level.isClientSide) {
            return InteractionResult.CONSUME;
        }
        if (state.getValue((Property)PART) != BedPart.HEAD && !(state = level.getBlockState(pos = pos.relative((Direction)state.getValue((Property)FACING)))).is((Block)this)) {
            return InteractionResult.CONSUME;
        }
        if (((Boolean)state.getValue((Property)OCCUPIED)).booleanValue()) {
            if (!this.kickVillagerOutOfBed(level, pos)) {
                player.displayClientMessage((Component)Component.translatable((String)"block.minecraft.bed.occupied"), true);
            }
            return InteractionResult.SUCCESS;
        }
        player.startSleepInBed(pos).ifLeft(f -> {
            if (f.getMessage() != null) {
                player.displayClientMessage(f.getMessage(), true);
            }
        }).ifRight(s -> player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 200, 1)));
        return InteractionResult.SUCCESS;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return null;
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.camping.canbeplaced").setStyle(Style.EMPTY.withColor(5597999).withItalic(Boolean.valueOf(true))));
    }

    @NotNull
    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)this);
    }
}

