/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.camping.core.world.block;

import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.camping.core.registry.CampingItems;
import net.satisfy.camping.core.util.BackpackVariant;
import net.satisfy.camping.core.util.CampingUtil;
import net.satisfy.camping.core.world.BackpackContainer;
import net.satisfy.camping.core.world.block.BackpackBlockShapes;
import net.satisfy.camping.core.world.block.entity.BackpackBlockEntity;

@MethodsReturnNonnullByDefault
public class BackpackBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final Map<BackpackVariant, Map<Direction, VoxelShape>> SHAPES = new HashMap<BackpackVariant, Map<Direction, VoxelShape>>();
    private final BackpackVariant variant;
    private final MapCodec<BackpackBlock> codec;

    public BackpackBlock(BlockBehaviour.Properties properties, BackpackVariant variant) {
        super(properties);
        this.variant = variant;
        this.codec = BackpackBlock.simpleCodec(p -> new BackpackBlock((BlockBehaviour.Properties)p, this.variant));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity living, ItemStack stack) {
        super.setPlacedBy(level, pos, state, living, stack);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BackpackBlockEntity) {
            BackpackBlockEntity bbe = (BackpackBlockEntity)blockEntity;
            NonNullList<ItemStack> items = BackpackContainer.readFromItem(stack);
            for (int i = 0; i < items.size(); ++i) {
                bbe.setItem(i, (ItemStack)items.get(i));
            }
            bbe.setChanged();
        }
    }

    public BackpackVariant getVariant() {
        return this.variant;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return this.codec;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED});
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        FluidState fs = ctx.getLevel().getFluidState(ctx.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fs.getType() == Fluids.WATER));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPES.get((Object)this.variant).get(state.getValue((Property)FACING));
    }

    public RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.MODEL;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)level.getBlockEntity(pos));
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        ItemStack out = new ItemStack((ItemLike)this.asItem());
        BlockEntity be = (BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (be instanceof BackpackBlockEntity) {
            BackpackBlockEntity bbe = (BackpackBlockEntity)be;
            NonNullList items = NonNullList.withSize((int)24, (Object)ItemStack.EMPTY);
            for (int i = 0; i < items.size(); ++i) {
                items.set(i, (Object)bbe.getItem(i));
            }
            BackpackContainer.writeToItem(out, (NonNullList<ItemStack>)items);
        }
        return List.of(out);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BackpackBlockEntity(pos, state);
    }

    private Item getBackpackItem() {
        return switch (this.getVariant()) {
            default -> throw new MatchException(null, null);
            case BackpackVariant.WANDERER_BACKPACK -> CampingItems.WANDERER_BACKPACK;
            case BackpackVariant.LARGE_BACKPACK -> CampingItems.LARGE_BACKPACK;
            case BackpackVariant.SMALL_BACKPACK -> CampingItems.SMALL_BACKPACK;
            case BackpackVariant.WANDERER_BAG -> CampingItems.WANDERER_BAG;
            case BackpackVariant.SHEEPBAG -> CampingItems.SHEEPBAG;
            case BackpackVariant.GOODYBAG -> CampingItems.GOODYBAG;
        };
    }

    private void dropBlockWithContents(Level level, BlockPos pos, BackpackBlockEntity be) {
        ItemStack stack = new ItemStack((ItemLike)this.getBackpackItem());
        NonNullList items = NonNullList.withSize((int)24, (Object)ItemStack.EMPTY);
        for (int i = 0; i < items.size(); ++i) {
            items.set(i, (Object)be.getItem(i));
        }
        BackpackContainer.writeToItem(stack, (NonNullList<ItemStack>)items);
        if (be.hasCustomName()) {
            stack.set(DataComponents.CUSTOM_NAME, (Object)be.getCustomName());
        }
        ItemEntity ie = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, stack);
        ie.setDefaultPickUpDelay();
        level.addFreshEntity((Entity)ie);
    }

    protected ItemInteractionResult useItemOn(ItemStack held, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (player.isSpectator()) {
            return InteractionResult.CONSUME;
        }
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof BackpackBlockEntity) {
            BackpackBlockEntity backpack = (BackpackBlockEntity)be;
            if (player.isShiftKeyDown()) {
                level.destroyBlock(pos, false);
                return InteractionResult.CONSUME;
            }
            player.openMenu((MenuProvider)backpack);
            player.awardStat(Stats.OPEN_CHEST);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    private static Map<Direction, VoxelShape> generateShapes(Supplier<VoxelShape> supplier) {
        HashMap<Direction, VoxelShape> map = new HashMap<Direction, VoxelShape>();
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            map.put(dir, CampingUtil.rotateShape(Direction.NORTH, dir, supplier.get()));
        }
        return map;
    }

    static {
        SHAPES.put(BackpackVariant.SMALL_BACKPACK, BackpackBlock.generateShapes(BackpackBlockShapes.SMALL_BACKPACK));
        SHAPES.put(BackpackVariant.LARGE_BACKPACK, BackpackBlock.generateShapes(BackpackBlockShapes.LARGE_BACKPACK));
        SHAPES.put(BackpackVariant.WANDERER_BACKPACK, BackpackBlock.generateShapes(BackpackBlockShapes.WANDERER_BACKPACK));
        SHAPES.put(BackpackVariant.WANDERER_BAG, BackpackBlock.generateShapes(BackpackBlockShapes.WANDERER_BAG));
        SHAPES.put(BackpackVariant.GOODYBAG, BackpackBlock.generateShapes(BackpackBlockShapes.GOODYBAG));
        SHAPES.put(BackpackVariant.SHEEPBAG, BackpackBlock.generateShapes(BackpackBlockShapes.SHEEPBAG));
    }
}

