/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.camping.core.registry;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.satisfy.camping.Camping;
import net.satisfy.camping.core.registry.CampingBlockEntities;
import net.satisfy.camping.core.registry.CampingBlocks;
import net.satisfy.camping.core.registry.CampingItems;
import net.satisfy.camping.core.registry.CampingScreenHandlers;
import net.satisfy.camping.core.registry.NeoForgeCampingLootModifiers;
import net.satisfy.camping.core.registry.NeoForgeCampingRecipes;

public class NeoForgeRegistry {
    public static final CreativeModeTab CREATIVE_TAB = CreativeModeTab.builder().withTabsBefore(new ResourceKey[]{CreativeModeTabs.SPAWN_EGGS}).icon(() -> new ItemStack((ItemLike)CampingBlocks.GRILL)).title((Component)Component.translatable((String)"itemGroup.camping")).displayItems((p, out) -> CampingItems.CREATIVE_TAB_ITEMS.forEach(arg_0 -> ((CreativeModeTab.Output)out).accept(arg_0))).build();

    public static void register(IEventBus modEventBus) {
        NeoForgeRegistry.bind(modEventBus, Registries.BLOCK, CampingBlocks::register);
        NeoForgeRegistry.bind(modEventBus, Registries.BLOCK_ENTITY_TYPE, CampingBlockEntities::register);
        NeoForgeRegistry.bind(modEventBus, Registries.ITEM, CampingItems::register);
        NeoForgeRegistry.bind(modEventBus, Registries.CREATIVE_MODE_TAB, NeoForgeRegistry::registerTab);
        NeoForgeRegistry.bind(modEventBus, Registries.MENU, CampingScreenHandlers::register);
        NeoForgeRegistry.bind(modEventBus, NeoForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, NeoForgeCampingLootModifiers::register);
        NeoForgeRegistry.bind(modEventBus, Registries.RECIPE_SERIALIZER, NeoForgeCampingRecipes::register);
    }

    private static <T> void bind(IEventBus bus, ResourceKey<Registry<T>> registry, Consumer<BiConsumer<T, ResourceLocation>> source) {
        bus.addListener(event -> {
            if (registry.equals(event.getRegistryKey())) {
                source.accept((t, rl) -> event.register(registry, rl, () -> t));
            }
        });
    }

    public static void registerTab(BiConsumer<CreativeModeTab, ResourceLocation> consumer) {
        consumer.accept(CREATIVE_TAB, Camping.identifier("creative_tab"));
    }
}

