/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.camping.client.world.block.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.camping.core.world.block.GrillBlock;
import net.satisfy.camping.core.world.block.entity.GrillBlockEntity;

public class GrillRenderer
implements BlockEntityRenderer<GrillBlockEntity> {
    private static final float ITEM_SIZE = 0.3f;
    private static final float ITEM_DISPLAY_HEIGHT = 0.95f;
    private static final float ITEM_DISPLAY_OFFSET = -0.15625f;
    private final ItemRenderer itemRenderer;

    public GrillRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = context.getItemRenderer();
    }

    public void render(GrillBlockEntity grillBlockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        NonNullList<ItemStack> items = grillBlockEntity.getItems();
        int posLong = (int)grillBlockEntity.getBlockPos().asLong();
        Direction direction = (Direction)grillBlockEntity.getBlockState().getValue((Property)GrillBlock.FACING);
        for (int i = 0; i < items.size(); ++i) {
            ItemStack itemStack = (ItemStack)items.get(i);
            if (itemStack.isEmpty()) continue;
            poseStack.pushPose();
            poseStack.translate(0.5f, 0.95f, 0.5f);
            Direction itemDirection = Direction.from2DDataValue((int)((i + direction.get2DDataValue()) % 4));
            float rotation = -itemDirection.toYRot();
            poseStack.mulPose(Axis.YP.rotationDegrees(rotation));
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            poseStack.translate(-0.15625f, -0.15625f, 0.0f);
            poseStack.scale(0.3f, 0.3f, 0.3f);
            this.itemRenderer.renderStatic(itemStack, ItemDisplayContext.FIXED, combinedLight, combinedOverlay, poseStack, bufferSource, grillBlockEntity.getLevel(), posLong + i);
            poseStack.popPose();
        }
    }
}

