/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.camping;

import java.util.stream.Stream;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.satisfy.camping.client.gui.screens.inventory.BackpackScreen;
import net.satisfy.camping.client.model.EnderbagModel;
import net.satisfy.camping.client.model.EnderpackModel;
import net.satisfy.camping.client.model.GoodybagModel;
import net.satisfy.camping.client.model.LargeBackpackModel;
import net.satisfy.camping.client.model.SheepbagModel;
import net.satisfy.camping.client.model.SmallBackpackModel;
import net.satisfy.camping.client.model.WandererBackpackModel;
import net.satisfy.camping.client.model.WandererBagModel;
import net.satisfy.camping.client.renderer.entity.layers.BackpackRenderLayer;
import net.satisfy.camping.client.renderer.entity.layers.EnderpackRenderLayer;
import net.satisfy.camping.client.world.block.renderer.GrillRenderer;
import net.satisfy.camping.core.registry.CampingBlockEntities;
import net.satisfy.camping.core.registry.CampingBlocks;
import net.satisfy.camping.core.registry.CampingScreenHandlers;
import net.satisfy.camping.optional.NeoForgeCuriosHelper;
import net.satisfy.camping.platform.Services;

public class CampingClientNeoForge {
    public CampingClientNeoForge(IEventBus modEventBus) {
        modEventBus.addListener(event -> event.enqueueWork(() -> {
            ItemBlockRenderTypes.setRenderLayer((Block)CampingBlocks.GRILL, (RenderType)RenderType.cutout());
            for (Block block : Stream.concat(CampingBlocks.TENT_MAIN.values().stream(), Stream.concat(CampingBlocks.TENT_MAIN_HEAD.values().stream(), Stream.concat(CampingBlocks.TENT_RIGHT.values().stream(), CampingBlocks.TENT_HEAD_RIGHT.values().stream()))).toList()) {
                ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.cutout());
            }
            if (Services.PLATFORM.isModLoaded("curios")) {
                NeoForgeCuriosHelper.registerRenderersForCurios();
            }
        }));
        modEventBus.addListener(event -> event.registerBlockEntityRenderer(CampingBlockEntities.GRILL, GrillRenderer::new));
        modEventBus.addListener(event -> event.register(CampingScreenHandlers.BACKPACK, BackpackScreen::new));
        modEventBus.addListener(event -> {
            event.registerLayerDefinition(EnderpackModel.LAYER_LOCATION, EnderpackModel::createBodyLayer);
            event.registerLayerDefinition(EnderbagModel.LAYER_LOCATION, EnderbagModel::createBodyLayer);
            event.registerLayerDefinition(GoodybagModel.LAYER_LOCATION, GoodybagModel::createBodyLayer);
            event.registerLayerDefinition(LargeBackpackModel.LAYER_LOCATION, LargeBackpackModel::createBodyLayer);
            event.registerLayerDefinition(SheepbagModel.LAYER_LOCATION, SheepbagModel::createBodyLayer);
            event.registerLayerDefinition(SmallBackpackModel.LAYER_LOCATION, SmallBackpackModel::createBodyLayer);
            event.registerLayerDefinition(WandererBackpackModel.LAYER_LOCATION, WandererBackpackModel::createBodyLayer);
            event.registerLayerDefinition(WandererBagModel.LAYER_LOCATION, WandererBagModel::createBodyLayer);
        });
        modEventBus.addListener(event -> {
            PlayerRenderer slim;
            PlayerRenderer wide = (PlayerRenderer)event.getSkin(PlayerSkin.Model.WIDE);
            if (wide != null) {
                wide.addLayer((RenderLayer)new EnderpackRenderLayer((RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)wide));
                wide.addLayer((RenderLayer)new BackpackRenderLayer((RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)wide));
            }
            if ((slim = (PlayerRenderer)event.getSkin(PlayerSkin.Model.SLIM)) != null) {
                slim.addLayer((RenderLayer)new EnderpackRenderLayer((RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)slim));
                slim.addLayer((RenderLayer)new BackpackRenderLayer((RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)slim));
            }
        });
    }
}

