/*
 * Decompiled with CFR 0.152.
 */
package com.zulu.kubejsoritech.mixin;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.crafting.RecipeManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RecipeManager.class})
public class RecipeManagerMixin {
    private static final Set<String> ORITECH_TYPES = Set.of("oritech:pulverizer", "oritech:grinder", "oritech:assembler", "oritech:centrifuge", "oritech:foundry", "oritech:laser", "oritech:atomic_forge", "oritech:particle_collision", "oritech:cooler", "oritech:refinery", "oritech:centrifuge_fluid");

    @Inject(method={"apply(Ljava/util/Map;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)V"}, at={@At(value="HEAD")})
    private void kubejsOritech$addMissingFields(Map<ResourceLocation, JsonElement> recipes, ResourceManager resourceManager, ProfilerFiller profiler, CallbackInfo ci) {
        for (Map.Entry<ResourceLocation, JsonElement> entry : recipes.entrySet()) {
            String type;
            JsonObject json;
            if (!entry.getValue().isJsonObject() || !(json = entry.getValue().getAsJsonObject()).has("type") || !ORITECH_TYPES.contains(type = json.get("type").getAsString())) continue;
            if (!json.has("ingredients")) {
                json.add("ingredients", (JsonElement)new JsonArray());
            }
            if (!json.has("results")) {
                json.add("results", (JsonElement)new JsonArray());
            }
            if (!json.has("fluidInput")) {
                JsonObject emptyFluid = new JsonObject();
                emptyFluid.addProperty("fluid", "minecraft:empty");
                emptyFluid.addProperty("amount", (Number)0);
                json.add("fluidInput", (JsonElement)emptyFluid);
            }
            if (json.has("fluidOutputs")) continue;
            json.add("fluidOutputs", (JsonElement)new JsonArray());
        }
    }
}

