/*
 * Decompiled with CFR 0.152.
 */
package com.zulu.kubejsoritech;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentType;
import dev.latvian.mods.kubejs.recipe.component.UniqueIdBuilder;
import dev.latvian.mods.kubejs.recipe.filter.RecipeMatchContext;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatchInfo;
import dev.latvian.mods.rhino.type.TypeInfo;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;

public record OritechFluidComponent(RecipeComponentType<?> type) implements RecipeComponent<FluidStack>
{
    public static final long BUCKET_AMOUNT = 81000L;
    public static final Codec<FluidStack> ORITECH_FLUID_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("fluid").forGetter(stack -> stack.isEmpty() ? ResourceLocation.withDefaultNamespace((String)"empty") : BuiltInRegistries.FLUID.getKey((Object)stack.getFluid())), (App)Codec.LONG.optionalFieldOf("amount", (Object)81000L).forGetter(stack -> stack.getAmount())).apply((Applicative)instance, (fluidId, amount) -> {
        if (fluidId.getPath().equals("empty")) {
            return FluidStack.EMPTY;
        }
        Fluid fluid = (Fluid)BuiltInRegistries.FLUID.get(fluidId);
        if (fluid == Fluids.EMPTY) {
            return FluidStack.EMPTY;
        }
        return new FluidStack(fluid, amount.intValue());
    }));
    public static final RecipeComponentType<FluidStack> TYPE = RecipeComponentType.unit((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"oritech", (String)"fluid"), OritechFluidComponent::new);

    public Codec<FluidStack> codec() {
        return ORITECH_FLUID_CODEC;
    }

    public TypeInfo typeInfo() {
        return TypeInfo.of(FluidStack.class);
    }

    public boolean hasPriority(RecipeMatchContext cx, Object from) {
        return from instanceof FluidStack || from instanceof Fluid;
    }

    public boolean matches(RecipeMatchContext cx, FluidStack value, ReplacementMatchInfo match) {
        return false;
    }

    public boolean isEmpty(FluidStack value) {
        return value == null || value.isEmpty();
    }

    public void buildUniqueId(UniqueIdBuilder builder, FluidStack value) {
        if (!this.isEmpty(value)) {
            builder.append(BuiltInRegistries.FLUID.getKey((Object)value.getFluid()));
        }
    }

    public boolean allowEmpty() {
        return true;
    }

    @Override
    public String toString() {
        return this.type.toString();
    }
}

