/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import dan200.computercraft.client.gui.NoTermComputerScreen;
import dan200.computercraft.client.render.CustomLecternRenderer;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.shared.lectern.PocketComputerLecternMenu;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.jspecify.annotations.Nullable;

public final class PocketComputerLecternScreen
extends NoTermComputerScreen<PocketComputerLecternMenu> {
    public PocketComputerLecternScreen(PocketComputerLecternMenu menu, Inventory player, Component title) {
        super(menu, player, title);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        Vector2ic position = this.getMousePosition();
        if (position != null) {
            this.computerInput.mouseClick(button + 1, position.x() + 1, position.y() + 1);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        Vector2ic position = this.getMousePosition();
        if (position != null) {
            this.computerInput.mouseDrag(button + 1, position.x() + 1, position.y() + 1);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        Vector2ic position = this.getMousePosition();
        if (position != null) {
            this.computerInput.mouseUp(button + 1, position.x() + 1, position.y() + 1);
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        Vector2ic position = this.getMousePosition();
        if (position != null && deltaY != 0.0) {
            this.computerInput.mouseScroll(deltaY < 0.0 ? 1 : -1, position.x(), position.y());
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }

    private @Nullable Vector2ic getMousePosition() {
        Minecraft minecraft = Objects.requireNonNull(this.minecraft);
        if (minecraft.level == null || minecraft.player == null || minecraft.hitResult == null) {
            return null;
        }
        BlockPos lecternPos = ((PocketComputerLecternMenu)this.getMenu()).lectern();
        Terminal terminal = ((PocketComputerLecternMenu)this.getMenu()).getTerminal();
        if (minecraft.hitResult.getType() != HitResult.Type.BLOCK || !((BlockHitResult)minecraft.hitResult).getBlockPos().equals((Object)lecternPos)) {
            return null;
        }
        PoseStack poseStack = new PoseStack();
        CustomLecternRenderer.applyLecternTransform(poseStack, minecraft.level.getBlockState(lecternPos));
        CustomLecternRenderer.applyPocketComputerTerminalTransform(poseStack);
        CustomLecternRenderer.applyScaledPocketComputerTerminalTransform(poseStack, terminal);
        Matrix4f inverseTransform = poseStack.last().pose().invert(new Matrix4f());
        Vec3 startPosition = minecraft.player.getEyePosition();
        Vector3f transformedStartPosition = inverseTransform.transformPosition((float)(startPosition.x() - (double)lecternPos.getX()), (float)(startPosition.y() - (double)lecternPos.getY()), (float)(startPosition.z() - (double)lecternPos.getZ()), new Vector3f());
        Vector3f transformedLookVector = inverseTransform.transformDirection(minecraft.player.getLookAngle().toVector3f());
        if (transformedLookVector.z() == 0.0f) {
            return null;
        }
        Vector3f intersection = transformedStartPosition.add((Vector3fc)transformedLookVector.mul(-transformedStartPosition.z() / transformedLookVector.z()));
        int positionX = (int)(intersection.x() / 6.0f);
        int positionY = (int)(intersection.y() / 9.0f);
        return positionX >= 0 && positionX < terminal.getWidth() && positionY >= 0 && positionY < terminal.getHeight() ? new Vector2i(positionX, positionY) : null;
    }
}

