/*
 * Decompiled with CFR 0.152.
 */
package com.lucasmellof.arkanis.voicemute.network.packets;

import com.lucasmellof.arkanis.voicemute.ArkanisVoiceChatClient;
import com.lucasmellof.arkanis.voicemute.Const;
import com.lucasmellof.arkanis.voicemute.network.Packet;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record StatusPacket(Status status) implements Packet
{
    public static final CustomPacketPayload.Type<StatusPacket> TYPE = new CustomPacketPayload.Type(Const.of("status"));
    public static final StreamCodec<ByteBuf, StatusPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.fromCodec(Status.CODEC), StatusPacket::status, StatusPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(StatusPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            ArkanisVoiceChatClient.status = packet.status;
        });
    }

    public static enum Status {
        MUTED,
        DEFAULT,
        GLOBAL_MUTED;

        public static final Codec<Status> CODEC;

        public int toId() {
            return this.ordinal();
        }

        public static Status fromId(int id) {
            return Status.values()[id % Status.values().length];
        }

        static {
            CODEC = Codec.INT.xmap(Status::fromId, Status::toId);
        }
    }
}

