/*
 * Decompiled with CFR 0.152.
 */
package com.lucasmellof.arkanis.voicemute.mixins;

import com.lucasmellof.arkanis.voicemute.VoiceUtils;
import de.maxhenkel.voicechat.plugins.PluginManager;
import de.maxhenkel.voicechat.voice.common.MicPacket;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import de.maxhenkel.voicechat.voice.server.PlayerStateManager;
import de.maxhenkel.voicechat.voice.server.Server;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={Server.class}, remap=false)
public abstract class MixinServer {
    @Shadow
    @Final
    private MinecraftServer server;
    @Shadow
    @Final
    private PlayerStateManager playerStateManager;

    @Shadow
    protected abstract void processMicPacket(ServerPlayer var1, PlayerState var2, MicPacket var3);

    @Overwrite
    public void onMicPacket(UUID playerUuid, MicPacket packet) {
        ServerPlayer player = this.server.getPlayerList().getPlayer(playerUuid);
        if (player == null) {
            return;
        }
        PlayerState state = this.playerStateManager.getState(player.getUUID());
        if (state == null) {
            return;
        }
        if (!VoiceUtils.INSTANCE.checkPlayer(player)) {
            return;
        }
        if (PluginManager.instance().onMicPacket(player, state, packet)) {
            return;
        }
        this.processMicPacket(player, state, packet);
    }
}

