/*
 * Decompiled with CFR 0.152.
 */
package com.lucasmellof.arkanis.voicemute.mixins;

import com.lucasmellof.arkanis.voicemute.ArkanisVoiceChatClient;
import com.lucasmellof.arkanis.voicemute.network.packets.StatusPacket;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientPlayerStateManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.GroupChatManager;
import de.maxhenkel.voicechat.voice.client.MicrophoneActivationType;
import de.maxhenkel.voicechat.voice.client.RenderEvents;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={RenderEvents.class}, remap=false)
public abstract class MixinRenderEvents {
    @Shadow
    @Final
    private static ResourceLocation DISCONNECT_ICON;
    @Shadow
    @Final
    private static ResourceLocation SPEAKER_OFF_ICON;
    @Shadow
    @Final
    private static ResourceLocation MICROPHONE_OFF_ICON;
    @Shadow
    @Final
    private static ResourceLocation WHISPER_MICROPHONE_ICON;
    @Shadow
    @Final
    private static ResourceLocation MICROPHONE_ICON;

    @Shadow
    protected abstract boolean shouldShowIcons();

    @Shadow
    protected abstract boolean isStartup();

    @Shadow
    protected abstract void renderIcon(GuiGraphics var1, ResourceLocation var2);

    @Overwrite
    private void onRenderHUD(GuiGraphics guiGraphics, float tickDelta) {
        if (!this.shouldShowIcons()) {
            return;
        }
        if (((Boolean)VoicechatClient.CLIENT_CONFIG.hideIcons.get()).booleanValue()) {
            return;
        }
        ClientPlayerStateManager manager = ClientManager.getPlayerStateManager();
        ClientVoicechat client = ClientManager.getClient();
        if (manager.isDisconnected() && this.isStartup()) {
            return;
        }
        if (manager.isDisconnected()) {
            this.renderIcon(guiGraphics, DISCONNECT_ICON);
        } else if (manager.isDisabled()) {
            this.renderIcon(guiGraphics, SPEAKER_OFF_ICON);
        } else if (manager.isMuted() && ((MicrophoneActivationType)VoicechatClient.CLIENT_CONFIG.microphoneActivationType.get()).equals((Object)MicrophoneActivationType.VOICE)) {
            this.renderIcon(guiGraphics, MICROPHONE_OFF_ICON);
        } else if (client != null && client.getMicThread() != null) {
            if (ArkanisVoiceChatClient.status == StatusPacket.Status.MUTED) {
                this.renderIcon(guiGraphics, MICROPHONE_OFF_ICON);
            } else if (client.getMicThread().isWhispering()) {
                this.renderIcon(guiGraphics, WHISPER_MICROPHONE_ICON);
            } else if (client.getMicThread().isTalking()) {
                this.renderIcon(guiGraphics, MICROPHONE_ICON);
            }
        }
        if (manager.getGroupID() != null && ((Boolean)VoicechatClient.CLIENT_CONFIG.showGroupHud.get()).booleanValue()) {
            GroupChatManager.renderIcons((GuiGraphics)guiGraphics);
        }
    }
}

