/*
 * Decompiled with CFR 0.152.
 */
package com.lucasmellof.arkanis.voicemute;

import com.lucasmellof.arkanis.voicemute.network.packets.StatusPacket;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class VoiceUtils {
    public static final VoiceUtils INSTANCE = new VoiceUtils();
    private final Set<UUID> mutedPlayers = Collections.synchronizedSet(new HashSet());
    public boolean allMuted = false;

    public boolean checkPlayer(ServerPlayer player) {
        if (this.mutedPlayers.contains(player.getUUID())) {
            return false;
        }
        if (player.hasPermissions(4)) {
            return true;
        }
        return !this.allMuted;
    }

    public boolean isMuted(ServerPlayer player) {
        return this.mutedPlayers.contains(player.getUUID());
    }

    public void mutePlayer(ServerPlayer player) {
        this.mutePlayer(player, true);
    }

    public void mutePlayer(ServerPlayer player, boolean save) {
        this.mutedPlayers.add(player.getUUID());
        if (save) {
            player.getPersistentData().putBoolean("ark:muted", true);
        }
        this.updateStatus(player, true);
    }

    public void unmutePlayer(ServerPlayer player) {
        this.unmutePlayer(player, true);
    }

    public void unmutePlayer(ServerPlayer player, boolean save) {
        this.mutedPlayers.remove(player.getUUID());
        if (save) {
            player.getPersistentData().remove("ark:muted");
        }
        this.updateStatus(player, false);
    }

    public void toggleMute(ServerPlayer player) {
        if (this.isMuted(player)) {
            this.unmutePlayer(player);
        } else {
            this.mutePlayer(player);
        }
    }

    public void muteAll() {
        this.allMuted = true;
        for (ServerPlayer player : ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayers()) {
            this.updateStatus(player, true);
        }
    }

    public void unmuteAll() {
        this.allMuted = false;
        for (ServerPlayer player : ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayers()) {
            this.updateStatus(player, false);
        }
    }

    public static boolean isMutedFromData(ServerPlayer player) {
        if (!player.getPersistentData().contains("ark:muted")) {
            return false;
        }
        return player.getPersistentData().getBoolean("ark:muted");
    }

    public void updateStatus(ServerPlayer player, boolean muted) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new StatusPacket(muted ? StatusPacket.Status.MUTED : StatusPacket.Status.DEFAULT), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

