/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel.server.generation;

import com.github.alexthe666.citadel.Citadel;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class VillageHouseManager {
    public static final List<ResourceLocation> VILLAGE_REPLACEMENT_POOLS = List.of(ResourceLocation.parse((String)"minecraft:village/plains/houses"), ResourceLocation.parse((String)"minecraft:village/desert/houses"), ResourceLocation.parse((String)"minecraft:village/savanna/houses"), ResourceLocation.parse((String)"minecraft:village/snowy/houses"), ResourceLocation.parse((String)"minecraft:village/taiga/houses"));
    private static final List<Pair<ResourceLocation, Consumer<StructureTemplatePool>>> REGISTRY = new ArrayList<Pair<ResourceLocation, Consumer<StructureTemplatePool>>>();

    public static void register(ResourceLocation pool, Consumer<StructureTemplatePool> addToPool) {
        REGISTRY.add((Pair<ResourceLocation, Consumer<StructureTemplatePool>>)new Pair((Object)pool, addToPool));
        Citadel.LOGGER.debug("registered addition to pool: {}", (Object)pool);
    }

    public static StructureTemplatePool addToPool(StructureTemplatePool pool, StructurePoolElement element, int weight) {
        ObjectArrayList templates;
        if (weight > 0 && pool != null && !(templates = new ObjectArrayList((ObjectList)pool.templates)).contains((Object)element)) {
            for (int i = 0; i < weight; ++i) {
                templates.add((Object)element);
            }
            ArrayList<Pair> rawTemplates = new ArrayList<Pair>(pool.rawTemplates);
            rawTemplates.add(new Pair((Object)element, (Object)weight));
            pool.templates = templates;
            pool.rawTemplates = rawTemplates;
            Citadel.LOGGER.info("Added to village structure pool");
        }
        return pool;
    }

    public static void addAllHouses(RegistryAccess registryAccess) {
        try {
            for (ResourceLocation villagePool : VILLAGE_REPLACEMENT_POOLS) {
                StructureTemplatePool pool = registryAccess.registryOrThrow(Registries.TEMPLATE_POOL).getOptional(villagePool).orElse(null);
                if (pool == null) continue;
                for (Pair<ResourceLocation, Consumer<StructureTemplatePool>> pair : REGISTRY) {
                    if (!villagePool.equals(pair.getFirst())) continue;
                    ((Consumer)pair.getSecond()).accept(pool);
                }
            }
        }
        catch (Exception e) {
            Citadel.LOGGER.error("Could not add village houses!");
            e.printStackTrace();
        }
    }
}

