/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel.server.generation;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.level.levelgen.SurfaceRules;

public class SurfaceRulesManager {
    private static final List<SurfaceRules.RuleSource> OVERWORLD_REGISTRY = new ArrayList<SurfaceRules.RuleSource>();
    private static final List<SurfaceRules.RuleSource> NETHER_REGISTRY = new ArrayList<SurfaceRules.RuleSource>();
    private static final List<SurfaceRules.RuleSource> END_REGISTRY = new ArrayList<SurfaceRules.RuleSource>();
    private static final List<SurfaceRules.RuleSource> CAVE_REGISTRY = new ArrayList<SurfaceRules.RuleSource>();

    public static void registerOverworldSurfaceRule(SurfaceRules.ConditionSource condition, SurfaceRules.RuleSource rule) {
        SurfaceRulesManager.registerOverworldSurfaceRule(SurfaceRules.ifTrue((SurfaceRules.ConditionSource)condition, (SurfaceRules.RuleSource)rule));
    }

    public static void registerOverworldSurfaceRule(SurfaceRules.RuleSource rule) {
        OVERWORLD_REGISTRY.add(rule);
    }

    public static void registerNetherSurfaceRule(SurfaceRules.ConditionSource condition, SurfaceRules.RuleSource rule) {
        SurfaceRulesManager.registerNetherSurfaceRule(SurfaceRules.ifTrue((SurfaceRules.ConditionSource)condition, (SurfaceRules.RuleSource)rule));
    }

    public static void registerNetherSurfaceRule(SurfaceRules.RuleSource rule) {
        NETHER_REGISTRY.add(rule);
    }

    public static void registerEndSurfaceRule(SurfaceRules.ConditionSource condition, SurfaceRules.RuleSource rule) {
        SurfaceRulesManager.registerEndSurfaceRule(SurfaceRules.ifTrue((SurfaceRules.ConditionSource)condition, (SurfaceRules.RuleSource)rule));
    }

    public static void registerEndSurfaceRule(SurfaceRules.RuleSource rule) {
        END_REGISTRY.add(rule);
    }

    public static void registerCaveSurfaceRule(SurfaceRules.ConditionSource condition, SurfaceRules.RuleSource rule) {
        SurfaceRulesManager.registerCaveSurfaceRule(SurfaceRules.ifTrue((SurfaceRules.ConditionSource)condition, (SurfaceRules.RuleSource)rule));
    }

    public static void registerCaveSurfaceRule(SurfaceRules.RuleSource rule) {
        CAVE_REGISTRY.add(rule);
    }

    public static SurfaceRules.RuleSource mergeRules(SurfaceRules.RuleSource prev, List<SurfaceRules.RuleSource> toMerge) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(toMerge);
        builder.add((Object)prev);
        return SurfaceRules.sequence((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])builder.build().toArray(SurfaceRules.RuleSource[]::new)));
    }

    public static SurfaceRules.RuleSource mergeOverworldRules(SurfaceRules.RuleSource rulesIn) {
        return SurfaceRulesManager.mergeRules(rulesIn, OVERWORLD_REGISTRY);
    }
}

