/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel.server.block;

import com.github.alexthe666.citadel.server.block.CitadelLecternBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class CitadelLecternBlock
extends LecternBlock {
    public CitadelLecternBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState blockState) {
        return new CitadelLecternBlockEntity(pos, blockState);
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack book;
        CitadelLecternBlockEntity lecternBlockEntity;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (level.isClientSide && blockEntity instanceof CitadelLecternBlockEntity && (lecternBlockEntity = (CitadelLecternBlockEntity)blockEntity).hasBook() && !(book = lecternBlockEntity.getBook()).isEmpty() && !player.getCooldowns().isOnCooldown(book.getItem())) {
            book.use(level, player, hand);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockentity;
        if (((Boolean)state.getValue((Property)HAS_BOOK)).booleanValue() && (blockentity = level.getBlockEntity(pos)) instanceof CitadelLecternBlockEntity) {
            return ((CitadelLecternBlockEntity)blockentity).getRedstoneSignal();
        }
        return 0;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState replaceState, boolean b) {
        if (!state.is(replaceState.getBlock())) {
            if (((Boolean)state.getValue((Property)HAS_BOOK)).booleanValue()) {
                this.popCitadelBook(state, level, pos);
            }
            if (((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
                level.updateNeighborsAt(pos.below(), (Block)this);
            }
            super.onRemove(state, level, pos, replaceState, b);
        }
    }

    private void popCitadelBook(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof CitadelLecternBlockEntity) {
            CitadelLecternBlockEntity lecternblockentity = (CitadelLecternBlockEntity)blockentity;
            Direction direction = (Direction)state.getValue((Property)FACING);
            ItemStack itemstack = lecternblockentity.getBook().copy();
            float f = 0.25f * (float)direction.getStepX();
            float f1 = 0.25f * (float)direction.getStepZ();
            ItemEntity itementity = new ItemEntity(level, (double)pos.getX() + 0.5 + (double)f, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5 + (double)f1, itemstack);
            itementity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)itementity);
            lecternblockentity.clearContent();
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)Items.LECTERN);
    }
}

