/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel.mixin.client;

import com.github.alexthe666.citadel.client.event.EventRenderSplashText;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.SplashRenderer;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.TriState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SplashRenderer.class})
public class SplashRendererMixin {
    @Mutable
    @Shadow
    @Final
    private String splash;
    private int splashTextColor = -1;

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;ILnet/minecraft/client/gui/Font;I)V"}, remap=true, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;mulPose(Lorg/joml/Quaternionf;)V", shift=At.Shift.BEFORE)})
    protected void citadel_preRenderSplashText(GuiGraphics guiGraphics, int width, Font font, int loadProgress, CallbackInfo ci) {
        guiGraphics.pose().pushPose();
        EventRenderSplashText.Pre event = new EventRenderSplashText.Pre(this.splash, guiGraphics, Minecraft.getInstance().getTimer().getRealtimeDeltaTicks(), 0xFFFF00);
        NeoForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == TriState.TRUE) {
            this.splash = event.getSplashText();
            this.splashTextColor = event.getSplashTextColor();
        }
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;ILnet/minecraft/client/gui/Font;I)V"}, remap=true, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;drawCenteredString(Lnet/minecraft/client/gui/Font;Ljava/lang/String;III)V", shift=At.Shift.AFTER)})
    protected void citadel_postRenderSplashText(GuiGraphics guiGraphics, int width, Font font, int loadProgress, CallbackInfo ci) {
        EventRenderSplashText.Post event = new EventRenderSplashText.Post(this.splash, guiGraphics, Minecraft.getInstance().getTimer().getRealtimeDeltaTicks());
        NeoForge.EVENT_BUS.post((Event)event);
        guiGraphics.pose().popPose();
    }

    @ModifyConstant(method={"render(Lnet/minecraft/client/gui/GuiGraphics;ILnet/minecraft/client/gui/Font;I)V"}, constant={@Constant(intValue=0xFFFF00)})
    private int citadel_splashTextColor(int value) {
        return this.splashTextColor == -1 ? value : this.splashTextColor;
    }
}

