/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel.item.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public record FancyItemDisplay(String displayItem, boolean displayBob, boolean displayZoom, float displayScale, boolean displaySpin, boolean displayShake) {
    public static final Codec<FancyItemDisplay> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("display_item").forGetter(FancyItemDisplay::displayItem), (App)Codec.BOOL.optionalFieldOf("display_bob", (Object)false).forGetter(FancyItemDisplay::displayBob), (App)Codec.BOOL.optionalFieldOf("display_zoom", (Object)false).forGetter(FancyItemDisplay::displayZoom), (App)Codec.FLOAT.optionalFieldOf("display_scale", (Object)Float.valueOf(1.0f)).forGetter(FancyItemDisplay::displayScale), (App)Codec.BOOL.optionalFieldOf("display_spin", (Object)false).forGetter(FancyItemDisplay::displaySpin), (App)Codec.BOOL.optionalFieldOf("display_shake", (Object)false).forGetter(FancyItemDisplay::displayShake)).apply((Applicative)instance, FancyItemDisplay::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, FancyItemDisplay> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, FancyItemDisplay>(){

        public FancyItemDisplay decode(RegistryFriendlyByteBuf buf) {
            String displayItem = buf.readUtf();
            boolean displayBob = buf.readBoolean();
            boolean displayZoom = buf.readBoolean();
            float displayScale = buf.readFloat();
            boolean displaySpin = buf.readBoolean();
            boolean displayShake = buf.readBoolean();
            return new FancyItemDisplay(displayItem, displayBob, displayZoom, displayScale, displaySpin, displayShake);
        }

        public void encode(RegistryFriendlyByteBuf buf, FancyItemDisplay value) {
            buf.writeUtf(value.displayItem());
            buf.writeBoolean(value.displayBob());
            buf.writeBoolean(value.displayZoom());
            buf.writeFloat(value.displayScale());
            buf.writeBoolean(value.displaySpin());
            buf.writeBoolean(value.displayShake());
        }
    };

    public FancyItemDisplay(String displayItem) {
        this(displayItem, false, false, 1.0f, false, false);
    }
}

