/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel.client.tick;

import com.github.alexthe666.citadel.server.tick.TickRateTracker;
import com.github.alexthe666.citadel.server.tick.modifier.TickRateModifier;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientTickRateTracker
extends TickRateTracker {
    public static final Logger LOGGER = LogManager.getLogger((String)"citadel-client-tick");
    private static Map<Minecraft, ClientTickRateTracker> dataMap = new HashMap<Minecraft, ClientTickRateTracker>();
    public Minecraft client;
    private static float MS_PER_TICK = 50.0f;

    public ClientTickRateTracker(Minecraft client) {
        this.client = client;
    }

    public void syncFromServer(CompoundTag tag) {
        this.tickRateModifierList.clear();
        this.fromTag(tag);
    }

    public static ClientTickRateTracker getForClient(Minecraft minecraft) {
        if (!dataMap.containsKey(minecraft)) {
            ClientTickRateTracker tracker = new ClientTickRateTracker(minecraft);
            dataMap.put(minecraft, tracker);
            return tracker;
        }
        return dataMap.get(minecraft);
    }

    @Override
    public void masterTick() {
        super.masterTick();
        DeltaTracker deltaTracker = this.client.getTimer();
        if (deltaTracker instanceof DeltaTracker.Timer) {
            DeltaTracker.Timer timer = (DeltaTracker.Timer)deltaTracker;
            timer.msPerTick = this.getClientTickRate();
        }
    }

    public float getClientTickRate() {
        float f = MS_PER_TICK;
        if (Minecraft.getInstance().level == null || Minecraft.getInstance().player == null) {
            return f;
        }
        for (TickRateModifier modifier : this.tickRateModifierList) {
            if (!modifier.appliesTo((Level)Minecraft.getInstance().level, Minecraft.getInstance().player.getX(), Minecraft.getInstance().player.getY(), Minecraft.getInstance().player.getZ())) continue;
            f *= modifier.getTickRateMultiplier();
        }
        return Math.max(1.0f, f * this.getEntityTickLengthModifier((Entity)Minecraft.getInstance().player));
    }

    public float modifySoundPitch(SoundInstance soundInstance) {
        float f = 1.0f;
        if (Minecraft.getInstance().level == null || Minecraft.getInstance().player == null) {
            return f;
        }
        for (TickRateModifier modifier : this.tickRateModifierList) {
            if (!modifier.appliesTo((Level)Minecraft.getInstance().level, Minecraft.getInstance().player.getX(), Minecraft.getInstance().player.getY(), Minecraft.getInstance().player.getZ())) continue;
            f /= modifier.getTickRateMultiplier();
        }
        return Math.max(1.0f, f * this.getEntityTickLengthModifier((Entity)Minecraft.getInstance().player));
    }

    @Override
    public void tickEntityAtCustomRate(Entity entity) {
        if (entity.level().isClientSide && entity.level() instanceof ClientLevel) {
            ((ClientLevel)entity.level()).tickNonPassenger(entity);
        }
    }
}

