/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel.client.rewards;

import com.github.alexthe666.citadel.server.entity.CitadelEntityData;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class CitadelCapes {
    private static final List<Cape> CAPES = new ArrayList<Cape>();
    private static final Map<UUID, Boolean> HAS_CAPES_ENABLED = new LinkedHashMap<UUID, Boolean>();

    public static void addCapeFor(List<UUID> uuids, String translationKey, ResourceLocation texture) {
        CAPES.add(new Cape(uuids, translationKey, texture));
    }

    public static List<Cape> getCapesFor(UUID uuid) {
        return CAPES.isEmpty() ? CAPES : CAPES.stream().filter(cape -> cape.isFor(uuid)).toList();
    }

    public static Cape getNextCape(String currentID, UUID playerUUID) {
        if (CAPES.isEmpty()) {
            return null;
        }
        int currentIndex = -1;
        for (int i = 0; i < CAPES.size(); ++i) {
            if (!CAPES.get(i).getIdentifier().equals(currentID)) continue;
            currentIndex = i;
            break;
        }
        boolean flag = false;
        for (int i = currentIndex + 1; i < CAPES.size(); ++i) {
            if (!CAPES.get(i).isFor(playerUUID)) continue;
            return CAPES.get(i);
        }
        return null;
    }

    @Nullable
    public static Cape getById(String identifier) {
        for (Cape cape : CAPES) {
            if (!cape.getIdentifier().equals(identifier)) continue;
            return cape;
        }
        return null;
    }

    @Nullable
    private static Cape getFirstApplicable(Player player) {
        for (Cape cape : CAPES) {
            if (!cape.isFor(player.getUUID())) continue;
            return cape;
        }
        return null;
    }

    public static Cape getCurrentCape(Player player) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)player);
        if (tag.getBoolean("CitadelCapeDisabled")) {
            return null;
        }
        if (tag.contains("CitadelCapeType")) {
            if (tag.getString("CitadelCapeType").isEmpty()) {
                return CitadelCapes.getFirstApplicable(player);
            }
            return CitadelCapes.getById(tag.getString("CitadelCapeType"));
        }
        return null;
    }

    public static class Cape {
        private List<UUID> isFor;
        private String identifier;
        private ResourceLocation texture;

        public Cape(List<UUID> isFor, String identifier, ResourceLocation texture) {
            this.isFor = isFor;
            this.identifier = identifier;
            this.texture = texture;
        }

        public List<UUID> getIsFor() {
            return this.isFor;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public ResourceLocation getTexture() {
            return this.texture;
        }

        public boolean isFor(UUID uuid) {
            return this.isFor.contains(uuid);
        }
    }
}

