/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel.client.gui;

import com.github.alexthe666.citadel.client.rewards.CitadelPatreonRenderer;
import com.github.alexthe666.citadel.server.entity.CitadelEntityData;
import com.github.alexthe666.citadel.server.message.PropertiesMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.options.OptionsSubScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.client.gui.widget.ExtendedSlider;
import net.neoforged.neoforge.network.PacketDistributor;

public class GuiCitadelPatreonConfig
extends OptionsSubScreen {
    private ExtendedSlider distSlider;
    private ExtendedSlider speedSlider;
    private ExtendedSlider heightSlider;
    private Button changeButton;
    private float rotateDist;
    private float rotateSpeed;
    private float rotateHeight;
    private String followType;

    public GuiCitadelPatreonConfig(Screen parentScreenIn, Options gameSettingsIn) {
        super(parentScreenIn, gameSettingsIn, (Component)Component.translatable((String)"citadel.gui.patreon_customization"));
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)Minecraft.getInstance().player);
        float distance = tag.contains("CitadelRotateDistance") ? tag.getFloat("CitadelRotateDistance") : 2.0f;
        float speed = tag.contains("CitadelRotateSpeed") ? tag.getFloat("CitadelRotateSpeed") : 1.0f;
        float height = tag.contains("CitadelRotateHeight") ? tag.getFloat("CitadelRotateHeight") : 1.0f;
        this.rotateDist = GuiCitadelPatreonConfig.roundTo(distance, 3);
        this.rotateSpeed = GuiCitadelPatreonConfig.roundTo(speed, 3);
        this.rotateHeight = GuiCitadelPatreonConfig.roundTo(height, 3);
        this.followType = tag.contains("CitadelFollowerType") ? tag.getString("CitadelFollowerType") : "citadel";
    }

    private void setSliderValue(int i, float sliderValue) {
        boolean flag = false;
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)Minecraft.getInstance().player);
        if (i == 0) {
            this.rotateDist = GuiCitadelPatreonConfig.roundTo(sliderValue, 3);
            tag.putFloat("CitadelRotateDistance", this.rotateDist);
        } else if (i == 1) {
            this.rotateSpeed = GuiCitadelPatreonConfig.roundTo(sliderValue, 3);
            tag.putFloat("CitadelRotateSpeed", this.rotateSpeed);
        } else {
            this.rotateHeight = GuiCitadelPatreonConfig.roundTo(sliderValue, 3);
            tag.putFloat("CitadelRotateHeight", this.rotateHeight);
        }
        CitadelEntityData.setCitadelTag((LivingEntity)Minecraft.getInstance().player, tag);
        PacketDistributor.sendToServer((CustomPacketPayload)new PropertiesMessage("CitadelPatreonConfig", tag, Minecraft.getInstance().player.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static float roundTo(float value, int places) {
        return value;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 20, 0xFFFFFF);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    protected void init() {
        super.init();
        int i = this.width / 2;
        int j = this.height / 6;
        Button doneButton = Button.builder((Component)CommonComponents.GUI_DONE, p_213079_1_ -> this.minecraft.setScreen(this.lastScreen)).size(200, 20).pos(i - 100, j + 120).build();
        this.addRenderableWidget((GuiEventListener)doneButton);
        this.distSlider = new ExtendedSlider(i - 75 - 25, j + 30, 150, 20, (Component)Component.translatable((String)"citadel.gui.orbit_dist").append((Component)Component.translatable((String)": ")), (Component)Component.translatable((String)""), 0.125, 5.0, this.rotateDist, 0.1, 1, true){

            protected void applyValue() {
                GuiCitadelPatreonConfig.this.setSliderValue(0, (float)this.getValue());
            }
        };
        this.addRenderableWidget((GuiEventListener)this.distSlider);
        Button reset1Button = Button.builder((Component)Component.translatable((String)"citadel.gui.reset"), p_213079_1_ -> this.setSliderValue(0, 0.4f)).size(40, 20).pos(i - 75 + 135, j + 30).build();
        this.addRenderableWidget((GuiEventListener)reset1Button);
        this.speedSlider = new ExtendedSlider(i - 75 - 25, j + 60, 150, 20, (Component)Component.translatable((String)"citadel.gui.orbit_speed").append((Component)Component.translatable((String)": ")), (Component)Component.translatable((String)""), 0.0, 5.0, this.rotateSpeed, 0.1, 2, true){

            protected void applyValue() {
                GuiCitadelPatreonConfig.this.setSliderValue(1, (float)this.getValue());
            }
        };
        this.addRenderableWidget((GuiEventListener)this.speedSlider);
        Button reset2Button = Button.builder((Component)Component.translatable((String)"citadel.gui.reset"), p_213079_1_ -> this.setSliderValue(1, 0.2f)).size(40, 20).pos(i - 75 + 135, j + 60).build();
        this.addRenderableWidget((GuiEventListener)reset2Button);
        this.heightSlider = new ExtendedSlider(i - 75 - 25, j + 90, 150, 20, (Component)Component.translatable((String)"citadel.gui.orbit_height").append((Component)Component.translatable((String)": ")), (Component)Component.translatable((String)""), 0.0, 2.0, this.rotateHeight, 0.1, 2, true){

            protected void applyValue() {
                GuiCitadelPatreonConfig.this.setSliderValue(2, (float)this.getValue());
            }
        };
        this.addRenderableWidget((GuiEventListener)this.heightSlider);
        Button reset3Button = Button.builder((Component)Component.translatable((String)"citadel.gui.reset"), p_213079_1_ -> this.setSliderValue(2, 0.5f)).size(40, 20).pos(i - 75 + 135, j + 90).build();
        this.addRenderableWidget((GuiEventListener)reset3Button);
        this.changeButton = Button.builder((Component)this.getTypeText(), p_213079_1_ -> {
            this.followType = CitadelPatreonRenderer.getIdOfNext(this.followType);
            CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)Minecraft.getInstance().player);
            tag.putString("CitadelFollowerType", this.followType);
            CitadelEntityData.setCitadelTag((LivingEntity)Minecraft.getInstance().player, tag);
            PacketDistributor.sendToServer((CustomPacketPayload)new PropertiesMessage("CitadelPatreonConfig", tag, Minecraft.getInstance().player.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.changeButton.setMessage(this.getTypeText());
        }).size(200, 20).pos(i - 100, j).build();
        this.addRenderableWidget((GuiEventListener)this.changeButton);
    }

    protected void addOptions() {
    }

    private Component getTypeText() {
        return Component.translatable((String)"citadel.gui.follower_type").append((Component)Component.translatable((String)("citadel.follower." + this.followType)));
    }
}

