/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel.client.gui;

import com.github.alexthe666.citadel.client.gui.data.EntityLinkData;
import com.github.alexthe666.citadel.client.gui.data.EntityRenderData;
import com.github.alexthe666.citadel.client.gui.data.ImageData;
import com.github.alexthe666.citadel.client.gui.data.ItemRenderData;
import com.github.alexthe666.citadel.client.gui.data.LinkData;
import com.github.alexthe666.citadel.client.gui.data.RecipeData;
import com.github.alexthe666.citadel.client.gui.data.TabulaRenderData;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.util.GsonHelper;

public class BookPage {
    private static final TypeAdapterFactory OPTIONAL_FACTORY = new TypeAdapterFactory(){

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            Class rawType = type.getRawType();
            if (rawType != Optional.class) {
                return null;
            }
            Type innerType = ((ParameterizedType)type.getType()).getActualTypeArguments()[0];
            final TypeAdapter innerAdapter = gson.getAdapter(TypeToken.get((Type)innerType));
            return new TypeAdapter<Optional<?>>(this){

                public void write(JsonWriter out, Optional<?> value) throws IOException {
                    if (value == null || value.isEmpty()) {
                        out.nullValue();
                    } else {
                        innerAdapter.write(out, value.get());
                    }
                }

                public Optional<?> read(JsonReader in) throws IOException {
                    if (in.peek() == JsonToken.NULL) {
                        in.nextNull();
                        return Optional.empty();
                    }
                    return Optional.ofNullable(innerAdapter.read(in));
                }
            };
        }
    };
    public static final Gson GSON = new GsonBuilder().registerTypeAdapterFactory(OPTIONAL_FACTORY).registerTypeAdapter(BookPage.class, (Object)new Deserializer()).create();
    public String translatableTitle = null;
    private String parent = "";
    private String textFileToReadFrom = "";
    private List<LinkData> linkedButtons = new ArrayList<LinkData>();
    private List<EntityLinkData> linkedEntites = new ArrayList<EntityLinkData>();
    private List<ItemRenderData> itemRenders = new ArrayList<ItemRenderData>();
    private List<RecipeData> recipes = new ArrayList<RecipeData>();
    private List<TabulaRenderData> tabulaRenders = new ArrayList<TabulaRenderData>();
    private List<EntityRenderData> entityRenders = new ArrayList<EntityRenderData>();
    private List<ImageData> images = new ArrayList<ImageData>();
    private final String title;

    public BookPage(String parent, String textFileToReadFrom, List<LinkData> linkedButtons, List<EntityLinkData> linkedEntities, List<ItemRenderData> itemRenders, List<RecipeData> recipes, List<TabulaRenderData> tabulaRenders, List<EntityRenderData> entityRenders, List<ImageData> images, String title) {
        this.parent = parent;
        this.textFileToReadFrom = textFileToReadFrom;
        this.linkedButtons = linkedButtons;
        this.itemRenders = itemRenders;
        this.linkedEntites = linkedEntities;
        this.recipes = recipes;
        this.tabulaRenders = tabulaRenders;
        this.entityRenders = entityRenders;
        this.images = images;
        this.title = title;
    }

    public static BookPage deserialize(Reader readerIn) {
        return (BookPage)GsonHelper.fromJson((Gson)GSON, (Reader)readerIn, BookPage.class);
    }

    public static BookPage deserialize(String jsonString) {
        return BookPage.deserialize(new StringReader(jsonString));
    }

    public String getParent() {
        return this.parent;
    }

    public String getTitle() {
        return this.title;
    }

    public String getTextFileToReadFrom() {
        return this.textFileToReadFrom;
    }

    public List<LinkData> getLinkedButtons() {
        return this.linkedButtons;
    }

    public List<EntityLinkData> getLinkedEntities() {
        return this.linkedEntites;
    }

    public List<ItemRenderData> getItemRenders() {
        return this.itemRenders;
    }

    public List<RecipeData> getRecipes() {
        return this.recipes;
    }

    public List<TabulaRenderData> getTabulaRenders() {
        return this.tabulaRenders;
    }

    public List<EntityRenderData> getEntityRenders() {
        return this.entityRenders;
    }

    public List<ImageData> getImages() {
        return this.images;
    }

    public String generateTitle() {
        if (this.translatableTitle != null) {
            return I18n.get((String)this.translatableTitle, (Object[])new Object[0]);
        }
        return this.title;
    }

    public static class Deserializer
    implements JsonDeserializer<BookPage> {
        private static final Gson ARRAY_GSON = new GsonBuilder().create();

        private <T> T[] safeGetArray(JsonObject jsonobject, String key, T[] defaultValue, Class<T[]> clazz) {
            if (!jsonobject.has(key)) {
                return defaultValue;
            }
            try {
                return (Object[])ARRAY_GSON.fromJson(jsonobject.get(key), clazz);
            }
            catch (Exception e) {
                return defaultValue;
            }
        }

        public BookPage deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            JsonObject jsonobject = GsonHelper.convertToJsonObject((JsonElement)p_deserialize_1_, (String)"book page");
            LinkData[] linkedPageRead = this.safeGetArray(jsonobject, "linked_page_buttons", new LinkData[0], LinkData[].class);
            EntityLinkData[] linkedEntitesRead = this.safeGetArray(jsonobject, "entity_buttons", new EntityLinkData[0], EntityLinkData[].class);
            ItemRenderData[] itemRendersRead = this.safeGetArray(jsonobject, "item_renders", new ItemRenderData[0], ItemRenderData[].class);
            RecipeData[] recipesRead = this.safeGetArray(jsonobject, "recipes", new RecipeData[0], RecipeData[].class);
            TabulaRenderData[] tabulaRendersRead = this.safeGetArray(jsonobject, "tabula_renders", new TabulaRenderData[0], TabulaRenderData[].class);
            EntityRenderData[] entityRendersRead = this.safeGetArray(jsonobject, "entity_renders", new EntityRenderData[0], EntityRenderData[].class);
            ImageData[] imagesRead = this.safeGetArray(jsonobject, "images", new ImageData[0], ImageData[].class);
            String readParent = "";
            if (jsonobject.has("parent")) {
                readParent = GsonHelper.getAsString((JsonObject)jsonobject, (String)"parent");
            }
            String readTextFile = "";
            if (jsonobject.has("text")) {
                readTextFile = GsonHelper.getAsString((JsonObject)jsonobject, (String)"text");
            }
            String title = "";
            if (jsonobject.has("title")) {
                title = GsonHelper.getAsString((JsonObject)jsonobject, (String)"title");
            }
            BookPage page = new BookPage(readParent, readTextFile, Arrays.asList(linkedPageRead), Arrays.asList(linkedEntitesRead), Arrays.asList(itemRendersRead), Arrays.asList(recipesRead), Arrays.asList(tabulaRendersRead), Arrays.asList(entityRendersRead), Arrays.asList(imagesRead), title);
            if (jsonobject.has("title")) {
                page.translatableTitle = GsonHelper.getAsString((JsonObject)jsonobject, (String)"title");
            }
            return page;
        }
    }
}

