/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel.client.game;

import com.github.alexthe666.citadel.client.game.TetrominoShape;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.awt.Color;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;

public class Tetris {
    protected final RandomSource random = RandomSource.create();
    private boolean started = false;
    private int score;
    private int renderTime = 0;
    private int keyCooldown;
    private static int HEIGHT = 20;
    private TetrominoShape fallingShape;
    private BlockState fallingBlock;
    private float fallingX;
    private float prevFallingY;
    private float fallingY;
    private Rotation fallingRotation;
    private BlockState[][] settledBlocks = new BlockState[10][HEIGHT];
    private boolean gameOver = false;
    private TetrominoShape nextShape;
    private BlockState nextBlock;
    private boolean[] flashingLayer = new boolean[HEIGHT];
    private int flashFor = 0;

    public Tetris() {
        this.reset();
    }

    public void tick() {
        ++this.renderTime;
        this.prevFallingY = this.fallingY;
        if (this.keyCooldown > 0) {
            --this.keyCooldown;
        }
        if (this.started && !this.gameOver) {
            if (this.fallingShape == null) {
                this.generateTetromino();
                this.generateNextTetromino();
            } else if (this.groundedTetromino()) {
                this.groundTetromino();
                this.fallingShape = null;
            } else {
                float f = 0.15f;
                if (InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)264)) {
                    f = 1.0f;
                }
                this.fallingY += f;
                if (this.keyPressed(263) && !this.isBlocksInOffset(-1, 0)) {
                    this.fallingX = this.restrictTetrominoX((int)(Math.floor(this.fallingX) - 1.0));
                }
                if (this.keyPressed(262) && !this.isBlocksInOffset(1, 0)) {
                    this.fallingX = this.restrictTetrominoX((int)(Math.ceil(this.fallingX) + 1.0));
                }
                if (this.keyPressed(265) && this.fallingRotation != null && this.fallingShape != TetrominoShape.SQUARE) {
                    this.fallingRotation = this.fallingRotation.getRotated(Rotation.CLOCKWISE_90);
                    this.fallingX = this.restrictTetrominoX((int)Math.floor(this.fallingX));
                }
            }
        }
        if (this.flashFor > 0) {
            --this.flashFor;
            if (this.flashFor == 0) {
                for (int j = 0; j < HEIGHT; ++j) {
                    if (!this.flashingLayer[j]) continue;
                    for (int k = j; k < HEIGHT; ++k) {
                        for (int i = 0; i < 10; ++i) {
                            this.settledBlocks[i][k] = k < HEIGHT - 1 ? this.settledBlocks[i][k + 1] : null;
                        }
                    }
                }
                int cleared = 0;
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.PLAYER_LEVELUP, (float)1.0f));
                for (int i = 0; i < this.flashingLayer.length; ++i) {
                    if (this.flashingLayer[i]) {
                        ++cleared;
                    }
                    this.flashingLayer[i] = false;
                }
                if (cleared == 1) {
                    this.score += 40;
                } else if (cleared == 2) {
                    this.score += 100;
                } else if (cleared == 3) {
                    this.score += 300;
                } else if (cleared >= 4) {
                    this.score += 1200 * (cleared - 3);
                }
            }
        }
        if (this.keyPressed(84)) {
            this.started = true;
            this.reset();
        }
    }

    private boolean groundedTetromino() {
        for (Vec3i vec : this.fallingShape.getRelativePositions()) {
            Vec3i vec2 = Tetris.transform(vec, this.fallingRotation, Vec3i.ZERO);
            int x = Math.round(this.fallingX) + vec2.getX();
            int y = HEIGHT - (int)Math.ceil(this.fallingY) - vec2.getY();
            if (y < 0) {
                return true;
            }
            if (x < 0 || x >= 10 || y >= HEIGHT || y != 0 && this.settledBlocks[x][y - 1] == null) continue;
            return true;
        }
        return false;
    }

    private void groundTetromino() {
        for (Vec3i vec : this.fallingShape.getRelativePositions()) {
            Vec3i vec2 = Tetris.transform(vec, this.fallingRotation, Vec3i.ZERO);
            int x = Math.round(this.fallingX) + vec2.getX();
            int y = HEIGHT - (int)Math.ceil(this.fallingY) - vec2.getY();
            if (x < 0 || x >= 10 || y < 0 || y >= HEIGHT) continue;
            if (y >= HEIGHT - 1) {
                this.gameOver = true;
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.PLAYER_DEATH, (float)1.0f));
            }
            if (this.settledBlocks[x][y] != null) continue;
            this.settledBlocks[x][y] = this.fallingBlock;
        }
        boolean flag = false;
        block1: for (int j = 0; j < HEIGHT; ++j) {
            for (int i = 0; i < 10 && this.settledBlocks[i][j] != null; ++i) {
                if (i != 9) continue;
                this.flashingLayer[j] = true;
                flag = true;
                continue block1;
            }
        }
        if (flag) {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.EXPERIENCE_ORB_PICKUP, (float)1.0f));
            this.flashFor = 20;
        }
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)this.fallingBlock.getSoundType().getPlaceSound(), (float)1.0f));
    }

    private boolean isBlocksInOffset(int xOffset, int yOffset) {
        for (Vec3i vec : this.fallingShape.getRelativePositions()) {
            Vec3i vec2 = Tetris.transform(vec, this.fallingRotation, Vec3i.ZERO);
            int x = Math.round(this.fallingX) + vec2.getX() + xOffset;
            int y = HEIGHT - (int)Math.ceil(this.fallingY) - vec2.getY() + yOffset;
            if (x < 0 || x >= 10 || y < 0 || y >= HEIGHT || y != 0 && this.settledBlocks[x][y] == null) continue;
            return true;
        }
        return false;
    }

    public boolean isStarted() {
        return this.started;
    }

    private boolean keyPressed(int keyId) {
        if (this.keyCooldown == 0 && InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)keyId)) {
            this.keyCooldown = 4;
            return true;
        }
        return false;
    }

    private void generateNextTetromino() {
        BlockState randomState = Blocks.DIRT.defaultBlockState();
        for (int tries = 0; tries < 5; ++tries) {
            try {
                BlockState block = ((Block)((Holder.Reference)BuiltInRegistries.BLOCK.getAny().get()).getDelegate().value()).defaultBlockState();
                BakedModel blockModel = Minecraft.getInstance().getBlockRenderer().getBlockModel(block);
                if (block.is(Blocks.GLOWSTONE) || blockModel.isCustomRenderer() || !blockModel.getRenderTypes(block, this.random, ModelData.EMPTY).contains(RenderType.solid())) continue;
                randomState = block;
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.nextShape = TetrominoShape.getRandom(this.random);
        this.nextBlock = randomState;
    }

    private void generateTetromino() {
        this.fallingShape = this.nextShape;
        this.fallingBlock = this.nextBlock;
        this.fallingRotation = Rotation.getRandom((RandomSource)this.random);
        this.fallingX = this.restrictTetrominoX(this.random.nextInt(10));
        this.prevFallingY = 0.0f;
        this.fallingY = -2.0f;
    }

    private int restrictTetrominoX(int xIn) {
        int minShapeX = 0;
        int maxShapeX = 0;
        for (Vec3i vec : this.fallingShape.getRelativePositions()) {
            Vec3i vec2 = Tetris.transform(vec, this.fallingRotation, Vec3i.ZERO);
            if (vec2.getX() < minShapeX) {
                minShapeX = vec2.getX();
            }
            if (vec2.getX() <= maxShapeX) continue;
            maxShapeX = vec2.getX();
        }
        if (xIn + minShapeX < 0) {
            xIn = Math.max(xIn - minShapeX, minShapeX);
        }
        if (xIn + maxShapeX > 9) {
            xIn = Math.min(xIn - maxShapeX, 9 - maxShapeX);
        }
        return xIn;
    }

    private void renderTetromino(TetrominoShape shape, BlockState blockState, Rotation fallingRotation, float x, float y, float scale, float offsetX, float offsetY) {
        for (Vec3i vec : shape.getRelativePositions()) {
            Vec3i vec2 = Tetris.transform(vec, fallingRotation, Vec3i.ZERO);
            this.renderBlockState(blockState, offsetX + (x + (float)vec2.getX()) * scale, offsetY + (y + (float)vec2.getY()) * scale, scale);
        }
    }

    private void renderBlockState(BlockState state, float offsetX, float offsetY, float size) {
        TextureAtlasSprite sprite = Minecraft.getInstance().getBlockRenderer().getBlockModel(state).getParticleIcon(ModelData.EMPTY);
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        float f = size * 0.5f;
        bufferbuilder.addVertex(-f + offsetX, f + offsetY, 80.0f).setUv(sprite.getU0(), sprite.getV1());
        bufferbuilder.addVertex(f + offsetX, f + offsetY, 80.0f).setUv(sprite.getU1(), sprite.getV1());
        bufferbuilder.addVertex(f + offsetX, -f + offsetY, 80.0f).setUv(sprite.getU1(), sprite.getV0());
        bufferbuilder.addVertex(-f + offsetX, -f + offsetY, 80.0f).setUv(sprite.getU0(), sprite.getV0());
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
    }

    public void render(TitleScreen screen, GuiGraphics guiGraphics, float partialTick) {
        float scale = Math.min((float)screen.width / 15.0f, (float)screen.height / (float)HEIGHT);
        float offsetX = (float)screen.width / 2.0f - scale * 5.0f;
        float offsetY = scale * 0.5f;
        if (this.started) {
            guiGraphics.fill(RenderType.guiOverlay(), (int)((float)screen.width * 0.05f), (int)((float)screen.height * 0.3f), (int)((float)screen.width * 0.05f) + 70, (int)((float)screen.height * 0.5f), -1873784752);
            guiGraphics.fill(RenderType.guiOverlay(), (int)((float)screen.width * 0.7f), (int)((float)screen.height * 0.3f), (int)((float)screen.width * 0.7f) + 130, (int)((float)screen.height * 0.84f), -1873784752);
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_BLOCKS);
            for (int i = 0; i < this.settledBlocks.length; ++i) {
                int max = this.settledBlocks[i].length;
                for (int j = 0; j < max; ++j) {
                    BlockState state = this.settledBlocks[i][j];
                    if (this.flashingLayer[j] && this.renderTime % 4 < 2) {
                        state = Blocks.GLOWSTONE.defaultBlockState();
                    }
                    if (state == null) continue;
                    this.renderBlockState(state, offsetX + (float)i * scale, offsetY + (float)(max - j - 1) * scale, scale);
                }
            }
            if (this.fallingShape != null) {
                float lerpedFallingY = this.prevFallingY + (this.fallingY - this.prevFallingY) * partialTick;
                this.renderTetromino(this.fallingShape, this.fallingBlock, this.fallingRotation, this.fallingX, lerpedFallingY, scale, offsetX, offsetY);
            }
            if (this.nextShape != null) {
                this.renderTetromino(this.nextShape, this.nextBlock, Rotation.NONE, 0.0f, 0.0f, scale, (float)screen.width * 0.85f, (float)screen.height * 0.4f);
            }
            float hue = (float)(System.currentTimeMillis() % 6000L) / 6000.0f;
            int rainbow = Color.HSBtoRGB(hue, 0.6f, 1.0f);
            guiGraphics.pose().pushPose();
            guiGraphics.pose().scale(2.0f, 2.0f, 2.0f);
            guiGraphics.drawCenteredString(Minecraft.getInstance().font, "SCORE", (int)((float)screen.width * 0.065f), (int)((float)screen.height * 0.175f), rainbow);
            guiGraphics.drawCenteredString(Minecraft.getInstance().font, "" + this.score, (int)((float)screen.width * 0.065f), (int)((float)screen.height * 0.175f) + 10, rainbow);
            guiGraphics.pose().popPose();
            guiGraphics.drawString(Minecraft.getInstance().font, "[LEFT ARROW] move left", (int)((float)screen.width * 0.71f), (int)((float)screen.height * 0.55f), rainbow);
            guiGraphics.drawString(Minecraft.getInstance().font, "[RIGHT ARROW] move right", (int)((float)screen.width * 0.71f), (int)((float)screen.height * 0.55f) + 10, rainbow);
            guiGraphics.drawString(Minecraft.getInstance().font, "[UP ARROW] rotate", (int)((float)screen.width * 0.71f), (int)((float)screen.height * 0.55f) + 20, rainbow);
            guiGraphics.drawString(Minecraft.getInstance().font, "[DOWN ARROW] quick drop", (int)((float)screen.width * 0.71f), (int)((float)screen.height * 0.55f) + 30, rainbow);
            guiGraphics.drawString(Minecraft.getInstance().font, "[T] start over", (int)((float)screen.width * 0.71f), (int)((float)screen.height * 0.55f) + 50, rainbow);
            guiGraphics.drawString(Minecraft.getInstance().font, "Happy april fools from Citadel", 5, 5, rainbow);
            if (this.gameOver) {
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate((float)((int)((float)screen.width * 0.5f)), (float)((int)((float)screen.height * 0.5f)), 150.0f);
                guiGraphics.pose().scale(3.0f + (float)Math.sin((double)hue * Math.PI) * 0.4f, 3.0f + (float)Math.sin((double)hue * Math.PI) * 0.4f, 3.0f + (float)Math.sin((double)hue * Math.PI) * 0.4f);
                guiGraphics.pose().mulPose(Axis.ZP.rotationDegrees((float)Math.sin((double)hue * Math.PI) * 10.0f));
                guiGraphics.drawCenteredString(Minecraft.getInstance().font, "GAME OVER", 0, 0, rainbow);
                guiGraphics.pose().popPose();
            }
        }
    }

    public void reset() {
        this.score = 0;
        for (Object[] objectArray : this.settledBlocks) {
            Arrays.fill(objectArray, null);
        }
        this.gameOver = false;
        Arrays.fill(this.flashingLayer, false);
        this.generateNextTetromino();
        this.generateTetromino();
        this.generateNextTetromino();
    }

    private static Vec3i transform(Vec3i vec3i, Rotation rotation, Vec3i relativeTo) {
        int i = vec3i.getX();
        int k = vec3i.getY();
        int j = vec3i.getZ();
        boolean flag = true;
        int l = relativeTo.getX();
        int i1 = relativeTo.getY();
        return switch (rotation) {
            case Rotation.COUNTERCLOCKWISE_90 -> new Vec3i(l - i1 + k, l + i1 - i, j);
            case Rotation.CLOCKWISE_90 -> new Vec3i(l + i1 - k, i1 - l + i, j);
            case Rotation.CLOCKWISE_180 -> new Vec3i(l + l - i, i1 + i1 - k, j);
            default -> new Vec3i(i, k, j);
        };
    }
}

