/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel;

import com.github.alexthe666.citadel.Citadel;
import com.github.alexthe666.citadel.CitadelConstants;
import com.github.alexthe666.citadel.ServerProxy;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.client.CitadelItemRenderProperties;
import com.github.alexthe666.citadel.client.event.EventRenderSplashText;
import com.github.alexthe666.citadel.client.game.Tetris;
import com.github.alexthe666.citadel.client.gui.GuiCitadelBook;
import com.github.alexthe666.citadel.client.gui.GuiCitadelCapesConfig;
import com.github.alexthe666.citadel.client.gui.GuiCitadelPatreonConfig;
import com.github.alexthe666.citadel.client.model.TabulaModel;
import com.github.alexthe666.citadel.client.model.TabulaModelHandler;
import com.github.alexthe666.citadel.client.render.CitadelLecternRenderer;
import com.github.alexthe666.citadel.client.render.pathfinding.WorldEventContext;
import com.github.alexthe666.citadel.client.rewards.CitadelCapes;
import com.github.alexthe666.citadel.client.rewards.CitadelPatreonRenderer;
import com.github.alexthe666.citadel.client.rewards.SpaceStationPatreonRenderer;
import com.github.alexthe666.citadel.client.shader.PostEffectRegistry;
import com.github.alexthe666.citadel.client.tick.ClientTickRateTracker;
import com.github.alexthe666.citadel.config.ServerConfig;
import com.github.alexthe666.citadel.item.ItemWithHoverAnimation;
import com.github.alexthe666.citadel.server.entity.CitadelEntityData;
import com.github.alexthe666.citadel.server.entity.pathfinding.raycoms.Pathfinding;
import com.github.alexthe666.citadel.server.event.EventChangeEntityTickRate;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.awt.Color;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.BackupConfirmScreen;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.options.SkinCustomizationScreen;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.RenderPlayerEvent;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.TriState;

public class ClientProxy
extends ServerProxy {
    public static TabulaModel CITADEL_MODEL;
    public static boolean hideFollower;
    private Map<ItemStack, Float> prevMouseOverProgresses = new HashMap<ItemStack, Float>();
    private Map<ItemStack, Float> mouseOverProgresses = new HashMap<ItemStack, Float>();
    private ItemStack lastHoveredItem = null;
    private Tetris aprilFoolsTetrisGame = null;
    public static final ResourceLocation RAINBOW_AURA_POST_SHADER;

    @Override
    public void onClientInit() {
        try {
            CITADEL_MODEL = new TabulaModel(TabulaModelHandler.INSTANCE.loadTabulaModel("/assets/citadel/models/citadel_model"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        BlockEntityRenderers.register(Citadel.LECTERN_BE.get(), CitadelLecternRenderer::new);
        CitadelPatreonRenderer.register("citadel", new SpaceStationPatreonRenderer(ResourceLocation.parse((String)"citadel:patreon_space_station"), new int[0]));
        CitadelPatreonRenderer.register("citadel_red", new SpaceStationPatreonRenderer(ResourceLocation.parse((String)"citadel:patreon_space_station_red"), new int[]{11685960, 10306880, 8009265, 7417898}));
        CitadelPatreonRenderer.register("citadel_gray", new SpaceStationPatreonRenderer(ResourceLocation.parse((String)"citadel:patreon_space_station_gray"), new int[]{0xA0A0A0, 0x888888, 0x646464, 0x575757}));
        if (CitadelConstants.debugShaders()) {
            PostEffectRegistry.registerEffect(RAINBOW_AURA_POST_SHADER);
        }
    }

    @SubscribeEvent
    public void screenOpen(ScreenEvent.Init.Post event) {
        if (event.getScreen() instanceof SkinCustomizationScreen && Minecraft.getInstance().player != null) {
            try {
                String username = Minecraft.getInstance().player.getName().getString();
                int height = -20;
                if (Citadel.PATREONS.contains(username)) {
                    Button button1 = Button.builder((Component)Component.translatable((String)"citadel.gui.patreon_rewards_option").withStyle(ChatFormatting.GREEN), p_213080_2_ -> Minecraft.getInstance().setScreen((Screen)new GuiCitadelPatreonConfig(event.getScreen(), Minecraft.getInstance().options))).size(200, 20).pos(event.getScreen().width / 2 - 100, event.getScreen().height / 6 + 150 + height).build();
                    event.addListener((GuiEventListener)button1);
                    height += 25;
                }
                if (!CitadelCapes.getCapesFor(Minecraft.getInstance().player.getUUID()).isEmpty()) {
                    Button button2 = Button.builder((Component)Component.translatable((String)"citadel.gui.capes_option").withStyle(ChatFormatting.GREEN), p_213080_2_ -> Minecraft.getInstance().setScreen((Screen)new GuiCitadelCapesConfig(event.getScreen(), Minecraft.getInstance().options))).size(200, 20).pos(event.getScreen().width / 2 - 100, event.getScreen().height / 6 + 150 + height).build();
                    event.addListener((GuiEventListener)button2);
                    height += 25;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void screenRender(ScreenEvent.Render.Post event) {
        if (event.getScreen() instanceof TitleScreen && CitadelConstants.isAprilFools()) {
            if (this.aprilFoolsTetrisGame == null) {
                this.aprilFoolsTetrisGame = new Tetris();
            } else {
                this.aprilFoolsTetrisGame.render((TitleScreen)event.getScreen(), event.getGuiGraphics(), event.getPartialTick());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void playerRender(RenderPlayerEvent.Pre event) {
        PoseStack matrixStackIn = event.getPoseStack();
        String username = event.getEntity().getName().getString();
        if (!event.getEntity().isModelPartShown(PlayerModelPart.CAPE) || event.isCanceled() || event.getEntity().isSpectator()) {
            return;
        }
        if (Citadel.PATREONS.contains(username)) {
            CitadelPatreonRenderer renderer;
            String rendererName;
            CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)Minecraft.getInstance().player);
            String string = rendererName = tag.contains("CitadelFollowerType") ? tag.getString("CitadelFollowerType") : "citadel";
            if (!rendererName.equals("none") && !hideFollower && (renderer = CitadelPatreonRenderer.get(rendererName)) != null) {
                float distance = tag.contains("CitadelRotateDistance") ? tag.getFloat("CitadelRotateDistance") : 2.0f;
                float speed = tag.contains("CitadelRotateSpeed") ? tag.getFloat("CitadelRotateSpeed") : 1.0f;
                float height = tag.contains("CitadelRotateHeight") ? tag.getFloat("CitadelRotateHeight") : 1.0f;
                renderer.render(matrixStackIn, event.getMultiBufferSource(), event.getPackedLight(), event.getPartialTick(), (LivingEntity)event.getEntity(), distance, speed, height);
            }
        }
    }

    @SubscribeEvent
    public void renderWorldLastEvent(RenderLevelStageEvent event) {
        if (Pathfinding.isDebug()) {
            WorldEventContext.INSTANCE.renderWorldLastEvent(event);
        }
    }

    @SubscribeEvent
    public void onOpenGui(ScreenEvent.Opening event) {
        if (ServerConfig.skipWarnings) {
            try {
                Screen title;
                Screen screen = event.getScreen();
                if (screen instanceof BackupConfirmScreen) {
                    BackupConfirmScreen confirmBackupScreen = (BackupConfirmScreen)screen;
                    title = Component.translatable((String)"selectWorld.backupQuestion.experimental");
                    if (confirmBackupScreen.getTitle().equals((Object)title)) {
                        confirmBackupScreen.onProceed.proceed(false, true);
                    }
                }
                if ((title = event.getScreen()) instanceof ConfirmScreen) {
                    ConfirmScreen confirmScreen = (ConfirmScreen)title;
                    title = Component.translatable((String)"selectWorld.backupQuestion.experimental");
                    if (confirmScreen.getTitle().equals((Object)title)) {
                        confirmScreen.callback.accept(true);
                    }
                }
            }
            catch (Exception e) {
                Citadel.LOGGER.warn("Citadel couldn't skip world loadings");
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void renderSplashTextBefore(EventRenderSplashText.Pre event) {
        if (CitadelConstants.isAprilFools() && this.aprilFoolsTetrisGame != null) {
            event.setResult(TriState.TRUE);
            float hue = (float)(System.currentTimeMillis() % 6000L) / 6000.0f;
            event.getGuiGraphics().pose().mulPose(Axis.ZP.rotationDegrees((float)Math.sin((double)hue * Math.PI) * 360.0f));
            if (!this.aprilFoolsTetrisGame.isStarted()) {
                event.setSplashText("Psst... press 'T' ;)");
            } else {
                event.setSplashText("");
            }
            int rainbow = Color.HSBtoRGB(hue, 0.6f, 1.0f);
            event.setSplashTextColor(rainbow);
        }
    }

    @SubscribeEvent
    public void onKeyPressed(ScreenEvent.KeyPressed.Pre event) {
        if (Minecraft.getInstance().screen instanceof TitleScreen && this.aprilFoolsTetrisGame != null && this.aprilFoolsTetrisGame.isStarted() && (event.getKeyCode() == 263 || event.getKeyCode() == 262 || event.getKeyCode() == 264 || event.getKeyCode() == 265)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void clientTick(ClientTickEvent.Pre event) {
        if (!this.isGamePaused() && Minecraft.getInstance().isRunning() && Minecraft.getInstance().level != null && Minecraft.getInstance().player != null) {
            ClientTickRateTracker.getForClient(Minecraft.getInstance()).masterTick();
            this.tickMouseOverAnimations();
        }
        if (!this.isGamePaused() && CitadelConstants.isAprilFools() && this.aprilFoolsTetrisGame != null) {
            if (Minecraft.getInstance().screen instanceof TitleScreen) {
                this.aprilFoolsTetrisGame.tick();
            } else {
                this.aprilFoolsTetrisGame.reset();
            }
        }
    }

    private void tickMouseOverAnimations() {
        this.prevMouseOverProgresses.putAll(this.mouseOverProgresses);
        if (this.lastHoveredItem != null) {
            float prev = this.mouseOverProgresses.getOrDefault(this.lastHoveredItem, Float.valueOf(0.0f)).floatValue();
            float maxTime = 5.0f;
            Item item = this.lastHoveredItem.getItem();
            if (item instanceof ItemWithHoverAnimation) {
                ItemWithHoverAnimation hoverOver = (ItemWithHoverAnimation)item;
                maxTime = hoverOver.getMaxHoverOverTime(this.lastHoveredItem);
            }
            if (prev < maxTime) {
                this.mouseOverProgresses.put(this.lastHoveredItem, Float.valueOf(prev + 1.0f));
            }
        }
        if (!this.mouseOverProgresses.isEmpty()) {
            Iterator<Map.Entry<ItemStack, Float>> it = this.mouseOverProgresses.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<ItemStack, Float> next = it.next();
                float progress = next.getValue().floatValue();
                if (this.lastHoveredItem != null && next.getKey() == this.lastHoveredItem) continue;
                if (progress == 0.0f) {
                    it.remove();
                    continue;
                }
                next.setValue(Float.valueOf(progress - 1.0f));
            }
        }
        this.lastHoveredItem = null;
    }

    @SubscribeEvent
    public void renderTooltipColor(RenderTooltipEvent.Color event) {
        ItemWithHoverAnimation hoverOver;
        Item item = event.getItemStack().getItem();
        this.lastHoveredItem = item instanceof ItemWithHoverAnimation && (hoverOver = (ItemWithHoverAnimation)item).canHoverOver(event.getItemStack()) ? event.getItemStack() : null;
    }

    @Override
    public float getMouseOverProgress(ItemStack itemStack) {
        float prev = this.prevMouseOverProgresses.getOrDefault(itemStack, Float.valueOf(0.0f)).floatValue();
        float current = this.mouseOverProgresses.getOrDefault(itemStack, Float.valueOf(0.0f)).floatValue();
        float lerped = prev + (current - prev) * (float)Minecraft.getInstance().getFrameTimeNs();
        float maxTime = 5.0f;
        Item item = itemStack.getItem();
        if (item instanceof ItemWithHoverAnimation) {
            ItemWithHoverAnimation hoverOver = (ItemWithHoverAnimation)item;
            maxTime = hoverOver.getMaxHoverOverTime(itemStack);
        }
        return lerped / maxTime;
    }

    @Override
    public void handleAnimationPacket(int entityId, int index) {
        IAnimatedEntity entity;
        if (Minecraft.getInstance().level != null && (entity = (IAnimatedEntity)Minecraft.getInstance().level.getEntity(entityId)) != null) {
            if (index == -1) {
                entity.setAnimation(IAnimatedEntity.NO_ANIMATION);
            } else {
                entity.setAnimation(entity.getAnimations()[index]);
            }
            entity.setAnimationTick(0);
        }
    }

    @Override
    public void handlePropertiesPacket(String propertyID, CompoundTag compound, int entityID) {
        if (compound == null || Minecraft.getInstance().level == null) {
            return;
        }
        Entity entity = Minecraft.getInstance().level.getEntity(entityID);
        if ((propertyID.equals("CitadelPatreonConfig") || propertyID.equals("CitadelTagUpdate")) && entity instanceof LivingEntity) {
            CitadelEntityData.setCitadelTag((LivingEntity)entity, compound);
        }
    }

    @Override
    public void handleClientTickRatePacket(CompoundTag compound) {
        ClientTickRateTracker.getForClient(Minecraft.getInstance()).syncFromServer(compound);
    }

    @Override
    public Object getISTERProperties() {
        return new CitadelItemRenderProperties();
    }

    @Override
    public void openBookGUI(ItemStack book) {
        Minecraft.getInstance().setScreen((Screen)new GuiCitadelBook(book));
    }

    @Override
    public boolean isGamePaused() {
        return Minecraft.getInstance().isPaused();
    }

    @Override
    public Player getClientSidePlayer() {
        return Minecraft.getInstance().player;
    }

    @Override
    public boolean canEntityTickClient(Level level, Entity entity) {
        ClientTickRateTracker tracker = ClientTickRateTracker.getForClient(Minecraft.getInstance());
        if (tracker.isTickingHandled(entity)) {
            return false;
        }
        if (!tracker.hasNormalTickRate(entity)) {
            EventChangeEntityTickRate event = new EventChangeEntityTickRate(entity, tracker.getEntityTickLengthModifier(entity));
            NeoForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                return true;
            }
            tracker.addTickBlockedEntity(entity);
            return false;
        }
        return true;
    }

    @SubscribeEvent
    public void postRenderStage(RenderLevelStageEvent event) {
    }

    static {
        hideFollower = false;
        RAINBOW_AURA_POST_SHADER = ResourceLocation.parse((String)"citadel:shaders/post/rainbow_aura.json");
    }
}

