/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.luminousbutterflies.network;

import java.util.function.Supplier;
import net.mcreator.luminousbutterflies.LuminousButterfliesMod;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class LuminousButterfliesModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"luminous_butterflies");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        LuminousButterfliesMod.addNetworkMessage(PlayerVariablesSyncMessage.TYPE, PlayerVariablesSyncMessage.STREAM_CODEC, PlayerVariablesSyncMessage::handleData);
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"luminous_butterflies", (String)"player_variables_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> buffer.writeNbt((Tag)message.data().serializeNBT((HolderLookup.Provider)buffer.registryAccess())), buffer -> {
            PlayerVariablesSyncMessage message = new PlayerVariablesSyncMessage(new PlayerVariables());
            message.data.deserializeNBT((HolderLookup.Provider)buffer.registryAccess(), buffer.readNbt());
            return message;
        });

        public CustomPacketPayload.Type<PlayerVariablesSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerVariablesSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> ((PlayerVariables)context.player().getData(PLAYER_VARIABLES)).deserializeNBT((HolderLookup.Provider)context.player().registryAccess(), message.data.serializeNBT((HolderLookup.Provider)context.player().registryAccess()))).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        public boolean Monarch = false;
        public boolean Blackswallowtail = false;
        public boolean Springazure = false;
        public boolean YellowSwallowtail = false;
        public boolean Buckeye = false;
        public boolean Hairstreak = false;
        public boolean Whitehairstreak = false;
        public boolean Bluemonarch = false;
        public boolean EmeraldSwallowtail = false;
        public boolean Rustypage = false;
        public boolean Littlewood = false;
        public boolean Zebralongwing = false;
        public boolean Orangetip = false;
        public boolean Mourningcloak = false;
        public boolean Charaxes = false;
        public boolean Ringlet = false;
        public boolean Cherryrose = false;
        public boolean Birdwing = false;
        public boolean SoulMonarch = false;
        public boolean CrimsonMonarch = false;
        public boolean GlowstoneMorpho = false;
        public boolean Enderfly = false;
        public boolean ChorusMorpho = false;

        public CompoundTag serializeNBT(HolderLookup.Provider lookupProvider) {
            CompoundTag nbt = new CompoundTag();
            nbt.putBoolean("Monarch", this.Monarch);
            nbt.putBoolean("Blackswallowtail", this.Blackswallowtail);
            nbt.putBoolean("Springazure", this.Springazure);
            nbt.putBoolean("YellowSwallowtail", this.YellowSwallowtail);
            nbt.putBoolean("Buckeye", this.Buckeye);
            nbt.putBoolean("Hairstreak", this.Hairstreak);
            nbt.putBoolean("Whitehairstreak", this.Whitehairstreak);
            nbt.putBoolean("Bluemonarch", this.Bluemonarch);
            nbt.putBoolean("EmeraldSwallowtail", this.EmeraldSwallowtail);
            nbt.putBoolean("Rustypage", this.Rustypage);
            nbt.putBoolean("Littlewood", this.Littlewood);
            nbt.putBoolean("Zebralongwing", this.Zebralongwing);
            nbt.putBoolean("Orangetip", this.Orangetip);
            nbt.putBoolean("Mourningcloak", this.Mourningcloak);
            nbt.putBoolean("Charaxes", this.Charaxes);
            nbt.putBoolean("Ringlet", this.Ringlet);
            nbt.putBoolean("Cherryrose", this.Cherryrose);
            nbt.putBoolean("Birdwing", this.Birdwing);
            nbt.putBoolean("SoulMonarch", this.SoulMonarch);
            nbt.putBoolean("CrimsonMonarch", this.CrimsonMonarch);
            nbt.putBoolean("GlowstoneMorpho", this.GlowstoneMorpho);
            nbt.putBoolean("Enderfly", this.Enderfly);
            nbt.putBoolean("ChorusMorpho", this.ChorusMorpho);
            return nbt;
        }

        public void deserializeNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
            this.Monarch = nbt.getBoolean("Monarch");
            this.Blackswallowtail = nbt.getBoolean("Blackswallowtail");
            this.Springazure = nbt.getBoolean("Springazure");
            this.YellowSwallowtail = nbt.getBoolean("YellowSwallowtail");
            this.Buckeye = nbt.getBoolean("Buckeye");
            this.Hairstreak = nbt.getBoolean("Hairstreak");
            this.Whitehairstreak = nbt.getBoolean("Whitehairstreak");
            this.Bluemonarch = nbt.getBoolean("Bluemonarch");
            this.EmeraldSwallowtail = nbt.getBoolean("EmeraldSwallowtail");
            this.Rustypage = nbt.getBoolean("Rustypage");
            this.Littlewood = nbt.getBoolean("Littlewood");
            this.Zebralongwing = nbt.getBoolean("Zebralongwing");
            this.Orangetip = nbt.getBoolean("Orangetip");
            this.Mourningcloak = nbt.getBoolean("Mourningcloak");
            this.Charaxes = nbt.getBoolean("Charaxes");
            this.Ringlet = nbt.getBoolean("Ringlet");
            this.Cherryrose = nbt.getBoolean("Cherryrose");
            this.Birdwing = nbt.getBoolean("Birdwing");
            this.SoulMonarch = nbt.getBoolean("SoulMonarch");
            this.CrimsonMonarch = nbt.getBoolean("CrimsonMonarch");
            this.GlowstoneMorpho = nbt.getBoolean("GlowstoneMorpho");
            this.Enderfly = nbt.getBoolean("Enderfly");
            this.ChorusMorpho = nbt.getBoolean("ChorusMorpho");
        }

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new PlayerVariablesSyncMessage(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
            PlayerVariables clone = new PlayerVariables();
            clone.Monarch = original.Monarch;
            clone.Blackswallowtail = original.Blackswallowtail;
            clone.Springazure = original.Springazure;
            clone.YellowSwallowtail = original.YellowSwallowtail;
            clone.Buckeye = original.Buckeye;
            clone.Hairstreak = original.Hairstreak;
            clone.Whitehairstreak = original.Whitehairstreak;
            clone.Bluemonarch = original.Bluemonarch;
            clone.EmeraldSwallowtail = original.EmeraldSwallowtail;
            clone.Rustypage = original.Rustypage;
            clone.Littlewood = original.Littlewood;
            clone.Zebralongwing = original.Zebralongwing;
            clone.Orangetip = original.Orangetip;
            clone.Mourningcloak = original.Mourningcloak;
            clone.Charaxes = original.Charaxes;
            clone.Ringlet = original.Ringlet;
            clone.Cherryrose = original.Cherryrose;
            clone.Birdwing = original.Birdwing;
            clone.SoulMonarch = original.SoulMonarch;
            clone.CrimsonMonarch = original.CrimsonMonarch;
            clone.GlowstoneMorpho = original.GlowstoneMorpho;
            clone.Enderfly = original.Enderfly;
            clone.ChorusMorpho = original.ChorusMorpho;
            if (!event.isWasDeath()) {
                // empty if block
            }
            event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
        }
    }
}

