/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.utils;

import io.github.lucaargolo.kibe.KibeMod;
import io.github.lucaargolo.kibe.fluid.FluidCompendium;
import io.github.lucaargolo.kibe.fluid.miscellaneous.LiquidXpFluid;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0015\u0010\u0013J#\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u00162\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0018\u00a2\u0006\u0004\b\u001a\u0010\u001bJ+\u0010\u001e\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020\u00108\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b \u0010!\u00a8\u0006\""}, d2={"Lio/github/lucaargolo/kibe/utils/XpUtils;", "", "<init>", "()V", "Lnet/fabricmc/fabric/api/transfer/v1/storage/Storage;", "Lnet/fabricmc/fabric/api/transfer/v1/fluid/FluidVariant;", "tank", "", "isTankValidXpDonor", "(Lnet/fabricmc/fabric/api/transfer/v1/storage/Storage;)Z", "", "nextLevelExp", "", "progress", "expToReachNextLvl", "(IF)I", "", "xp", "convertXpToMilibuckets", "(J)J", "milibuckets", "convertMilibucketsToXp", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/fabricmc/fabric/api/transfer/v1/storage/base/SingleVariantStorage;", "Lnet/minecraft/world/InteractionResult;", "donateXpAction", "(Lnet/minecraft/world/entity/player/Player;Lnet/fabricmc/fabric/api/transfer/v1/storage/base/SingleVariantStorage;)Lnet/minecraft/world/InteractionResult;", "Lnet/minecraft/world/InteractionHand;", "hand", "canPlayerDrinkXp", "(Lnet/fabricmc/fabric/api/transfer/v1/storage/Storage;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Z", "MB_PER_XP", "J", "kibe"})
@SourceDebugExtension(value={"SMAP\nXpUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XpUtils.kt\nio/github/lucaargolo/kibe/utils/XpUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n1#2:78\n*E\n"})
public final class XpUtils {
    @NotNull
    public static final XpUtils INSTANCE = new XpUtils();
    public static final long MB_PER_XP = 810L;

    private XpUtils() {
    }

    private final boolean isTankValidXpDonor(Storage<FluidVariant> tank2) {
        return tank2 instanceof SingleVariantStorage && ((FluidVariant)((SingleVariantStorage)tank2).variant).getFluid() instanceof LiquidXpFluid;
    }

    public final int expToReachNextLvl(int nextLevelExp, float progress) {
        return nextLevelExp - (int)((float)nextLevelExp * progress);
    }

    public final long convertXpToMilibuckets(long xp) {
        return 810L * xp;
    }

    public final long convertMilibucketsToXp(long milibuckets) {
        return milibuckets / 810L;
    }

    @NotNull
    public final InteractionResult donateXpAction(@NotNull Player player, @NotNull SingleVariantStorage<FluidVariant> tank2) {
        Transaction transaction;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter(tank2, (String)"tank");
        if (tank2.amount < 810L) {
            return InteractionResult.FAIL;
        }
        int xpToNextLevel = this.expToReachNextLvl(player.getXpNeededForNextLevel(), player.experienceProgress);
        long liquidXpToExtract = Math.min(this.convertXpToMilibuckets(xpToNextLevel), tank2.amount);
        Transaction transaction2 = transaction = Transaction.openOuter();
        boolean bl = false;
        Ref.LongRef extractedAmount = new Ref.LongRef();
        extractedAmount.element = -1L;
        long it = tank2.extract((TransferVariant)FluidVariant.of((Fluid)((Fluid)FluidCompendium.INSTANCE.getLIQUID_XP())), liquidXpToExtract, (TransactionContext)transaction2);
        boolean bl2 = false;
        extractedAmount.element = it;
        transaction2.addCloseCallback((arg_0, arg_1) -> XpUtils.donateXpAction$lambda$0$1(player, liquidXpToExtract, extractedAmount, arg_0, arg_1));
        transaction2.commit();
        InteractionResult interactionResult = InteractionResult.sidedSuccess((boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"success(...)");
        return interactionResult;
    }

    public final boolean canPlayerDrinkXp(@NotNull Storage<FluidVariant> tank2, @NotNull Player player, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter(tank2, (String)"tank");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        return KibeMod.INSTANCE.getCONFIG().getMiscellaneousModule().getXpTankDrinkOnRightClick() && player.getMainHandItem().isEmpty() && hand == InteractionHand.MAIN_HAND && this.isTankValidXpDonor(tank2);
    }

    private static final void donateXpAction$lambda$0$1(Player $player, long $liquidXpToExtract, Ref.LongRef $extractedAmount, TransactionContext transactionContext, TransactionContext.Result result) {
        if (result.wasAborted()) {
            return;
        }
        $player.giveExperiencePoints((int)INSTANCE.convertMilibucketsToXp($liquidXpToExtract));
        if ($extractedAmount.element > 0L) {
            $player.level().playSound(null, $player.blockPosition(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.AMBIENT, 0.5f, (float)$player.level().random.nextIntBetweenInclusive(3, 9) / (float)10);
        }
    }
}

