/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.utils;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0019\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\r\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0019\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\r\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0010J!\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0013J\u001f\u0010\u0016\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0019\u0010\u001c\u001a\u00020\n2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001aH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001e\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u0019R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001fR\u0017\u0010\u0004\u001a\u00020\u00018\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010 \u001a\u0004\b!\u0010\"\u00a8\u0006#"}, d2={"Lio/github/lucaargolo/kibe/utils/BlockEntityInventory;", "Lnet/minecraft/world/Container;", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "handler", "entity", "<init>", "(Lnet/minecraft/world/inventory/AbstractContainerMenu;Lnet/minecraft/world/Container;)V", "", "size", "()I", "", "isEmpty", "()Z", "slot", "Lnet/minecraft/world/item/ItemStack;", "getStack", "(I)Lnet/minecraft/world/item/ItemStack;", "removeStack", "amount", "(II)Lnet/minecraft/world/item/ItemStack;", "stack", "", "setStack", "(ILnet/minecraft/world/item/ItemStack;)V", "markDirty", "()V", "Lnet/minecraft/world/entity/player/Player;", "player", "canPlayerUse", "(Lnet/minecraft/world/entity/player/Player;)Z", "clear", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "Lnet/minecraft/world/Container;", "getEntity", "()Lnet/minecraft/world/Container;", "kibe"})
public final class BlockEntityInventory
implements Container {
    @NotNull
    private final AbstractContainerMenu handler;
    @NotNull
    private final Container entity;

    public BlockEntityInventory(@NotNull AbstractContainerMenu handler, @NotNull Container entity) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.handler = handler;
        this.entity = entity;
    }

    @NotNull
    public final Container getEntity() {
        return this.entity;
    }

    public int getContainerSize() {
        return this.entity.getContainerSize();
    }

    public boolean isEmpty() {
        return this.entity.isEmpty();
    }

    @Nullable
    public ItemStack getItem(int slot) {
        return this.entity.getItem(slot);
    }

    @Nullable
    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack itemStack = this.entity.removeItemNoUpdate(slot);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"removeStack(...)");
        ItemStack stack = itemStack;
        this.handler.slotsChanged((Container)this);
        return stack;
    }

    @Nullable
    public ItemStack removeItem(int slot, int amount) {
        ItemStack itemStack = this.entity.removeItem(slot, amount);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"removeStack(...)");
        ItemStack stack = itemStack;
        this.handler.slotsChanged((Container)this);
        return stack;
    }

    public void setItem(int slot, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        this.entity.setItem(slot, stack);
        this.handler.slotsChanged((Container)this);
    }

    public void setChanged() {
        this.entity.setChanged();
    }

    public boolean stillValid(@Nullable Player player) {
        return this.entity.stillValid(player);
    }

    public void clearContent() {
        this.entity.clearContent();
    }
}

