/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.recipes.vacuum;

import io.github.lucaargolo.kibe.blockentity.VacuumHopperEntity;
import io.github.lucaargolo.kibe.recipes.RecipeSerializerCompendium;
import io.github.lucaargolo.kibe.recipes.RecipeTypeCompendium;
import io.github.lucaargolo.kibe.recipes.vacuum.VacuumHopperRecipeSerializer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u00002\f\u0012\b\u0012\u00060\u0002R\u00020\u00030\u0001B'\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ#\u0010\u0011\u001a\u00020\u00102\n\u0010\t\u001a\u00060\u0002R\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J#\u0010\u0015\u001a\u00020\n2\n\u0010\t\u001a\u00060\u0002R\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00000\u0017H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001f\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010\u001f\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u000f\u0010\"\u001a\u00020!H\u0016\u00a2\u0006\u0004\b\"\u0010#J\u000f\u0010$\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b$\u0010%J\u0015\u0010'\u001a\b\u0012\u0004\u0012\u00020\b0&H\u0016\u00a2\u0006\u0004\b'\u0010(J\u000f\u0010)\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b)\u0010*R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010+\u001a\u0004\b,\u0010-R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010.\u001a\u0004\b/\u00100R\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u00101\u001a\u0004\b2\u00103R\u0017\u0010\u000b\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u00104\u001a\u0004\b5\u0010%\u00a8\u00066"}, d2={"Lio/github/lucaargolo/kibe/recipes/vacuum/VacuumHopperRecipe;", "Lnet/minecraft/world/item/crafting/Recipe;", "Lio/github/lucaargolo/kibe/blockentity/VacuumHopperEntity$Input;", "Lio/github/lucaargolo/kibe/blockentity/VacuumHopperEntity;", "", "ticks", "", "xp", "Lnet/minecraft/world/item/crafting/Ingredient;", "input", "Lnet/minecraft/world/item/ItemStack;", "output", "<init>", "(IJLnet/minecraft/world/item/crafting/Ingredient;Lnet/minecraft/world/item/ItemStack;)V", "Lnet/minecraft/world/level/Level;", "world", "", "matches", "(Lio/github/lucaargolo/kibe/blockentity/VacuumHopperEntity$Input;Lnet/minecraft/world/level/Level;)Z", "Lnet/minecraft/core/HolderLookup$Provider;", "lookup", "craft", "(Lio/github/lucaargolo/kibe/blockentity/VacuumHopperEntity$Input;Lnet/minecraft/core/HolderLookup$Provider;)Lnet/minecraft/world/item/ItemStack;", "Lnet/minecraft/world/item/crafting/RecipeType;", "getType", "()Lnet/minecraft/world/item/crafting/RecipeType;", "width", "height", "fits", "(II)Z", "registriesLookup", "getResult", "(Lnet/minecraft/core/HolderLookup$Provider;)Lnet/minecraft/world/item/ItemStack;", "Lio/github/lucaargolo/kibe/recipes/vacuum/VacuumHopperRecipeSerializer;", "getSerializer", "()Lio/github/lucaargolo/kibe/recipes/vacuum/VacuumHopperRecipeSerializer;", "createIcon", "()Lnet/minecraft/world/item/ItemStack;", "Lnet/minecraft/core/NonNullList;", "getIngredients", "()Lnet/minecraft/core/NonNullList;", "isIgnoredInRecipeBook", "()Z", "I", "getTicks", "()I", "J", "getXp", "()J", "Lnet/minecraft/world/item/crafting/Ingredient;", "getInput", "()Lnet/minecraft/world/item/crafting/Ingredient;", "Lnet/minecraft/world/item/ItemStack;", "getOutput", "kibe"})
public final class VacuumHopperRecipe
implements Recipe<VacuumHopperEntity.Input> {
    private final int ticks;
    private final long xp;
    @NotNull
    private final Ingredient input;
    @NotNull
    private final ItemStack output;

    public VacuumHopperRecipe(int ticks, long xp, @NotNull Ingredient input, @NotNull ItemStack output) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this.ticks = ticks;
        this.xp = xp;
        this.input = input;
        this.output = output;
    }

    public final int getTicks() {
        return this.ticks;
    }

    public final long getXp() {
        return this.xp;
    }

    @NotNull
    public final Ingredient getInput() {
        return this.input;
    }

    @NotNull
    public final ItemStack getOutput() {
        return this.output;
    }

    public boolean matches(@NotNull VacuumHopperEntity.Input input, @NotNull Level world) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        VacuumHopperEntity parent = input.getParent();
        ItemStack inputStack = parent.getItem(9);
        ItemStack it = parent.getItem(10);
        boolean bl = false;
        boolean hasSpace = it.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)it, (ItemStack)this.output) && it.getCount() < it.getMaxStackSize();
        return this.input.test(inputStack) && parent.getTank().amount >= this.xp * (long)81 && hasSpace;
    }

    @NotNull
    public ItemStack craft(@NotNull VacuumHopperEntity.Input input, @NotNull HolderLookup.Provider lookup) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        VacuumHopperEntity parent = input.getParent();
        parent.getItem(9).shrink(1);
        SingleVariantStorage<FluidVariant> singleVariantStorage = parent.getTank();
        singleVariantStorage.amount -= this.xp * (long)81;
        if (parent.getItem(10).isEmpty()) {
            parent.setItem(10, this.output.copy());
        } else {
            parent.getItem(10).grow(1);
        }
        parent.setChanged();
        ItemStack itemStack = this.output.copy();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copy(...)");
        return itemStack;
    }

    @NotNull
    public RecipeType<VacuumHopperRecipe> getType() {
        return RecipeTypeCompendium.INSTANCE.getVACUUM_HOPPER();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider registriesLookup) {
        Intrinsics.checkNotNullParameter((Object)registriesLookup, (String)"registriesLookup");
        return this.output;
    }

    @NotNull
    public VacuumHopperRecipeSerializer getSerializer() {
        return RecipeSerializerCompendium.INSTANCE.getVACUUM_HOPPER();
    }

    @NotNull
    public ItemStack getToastSymbol() {
        ItemStack itemStack = Items.EXPERIENCE_BOTTLE.getDefaultInstance();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getDefaultStack(...)");
        return itemStack;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        NonNullList nonNullList = NonNullList.withSize((int)1, (Object)this.input);
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"ofSize(...)");
        return nonNullList;
    }

    public boolean isSpecial() {
        return true;
    }
}

